<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Shipyari extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->library(['ion_auth', 'form_validation']);
        $this->load->helper(['url', 'language']);
        $this->load->model(['Home_model', 'Order_model']);
    }

    public function index()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
            $user_id = $this->session->userdata('user_id');
            $user_res = $this->db->select('balance,username')->where('id', $user_id)->get('users')->result_array();
            $this->data['main_page'] = FORMS . 'shipyari';
            $settings = get_settings('system_settings', true);        
            $this->data['title'] = 'Seller Panel | ' . $settings['app_name'];                        
            $this->data['shipyari'] = $this->db->where('user_id', $user_id)->get('shipyari_settings')->row();
            $this->load->view('seller/template', $this->data);
        } else {
            redirect('seller/login', 'refresh');
        }
    }

   public function update(){
    if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $this->response['error'] = true;
            $this->response['message'] = DEMO_VERSION_MSG;
            echo json_encode($this->response);
            return false;
            exit();
        }
        $user_id = $this->session->userdata('user_id');
        $username = $_POST['username'];
        $avn_key = $_POST['avn_key'];

        // Check if the user_id exists
        $this->db->where('user_id', $user_id);
        $query = $this->db->get('shipyari_settings');

        if ($query->num_rows() > 0) {

            $data = array(
                'username' => $username,
                'avn_key' => $avn_key
            );

            $this->db->where('user_id', $user_id);
            $this->db->update('shipyari_settings', $data);
        } else {
            $data = array(
                'user_id' => $user_id,
                'username' => $username,
                'avn_key' => $avn_key
            );
            $this->db->insert('shipyari_settings', $data);
        }

        $error = false;
        $message = 'Shipyari setting updated successfully';
        $response['error'] = $error;
        $response['csrfName'] = $this->security->get_csrf_token_name();
        $response['csrfHash'] = $this->security->get_csrf_hash();
        $response['message'] = $message;
        print_r(json_encode($response));
    } else {
        redirect('seller/login', 'refresh');
    }
   }
   public function create_shipyari_account(){
    if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
        $this->form_validation->set_rules('full_name', 'Full Name', 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean');
        $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|xss_clean');
        $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|xss_clean');
        

        if (!$this->form_validation->run()) {
            $this->response['error'] = true;
            $this->response['message'] = strip_tags(validation_errors());
            $this->response['data'] = array();
            $this->response['csrfName'] = $this->security->get_csrf_token_name();
            $this->response['csrfHash'] = $this->security->get_csrf_hash();
            print_r(json_encode($this->response));
            return false;
        }
        $array = [
            "full_name"=> $_POST['full_name'],
            "company_name"=> $_POST['company_name'],
            "email"=> $_POST['email'],
            "source"=> "zsms2",
            "phone_number"=> $_POST['phone']
        ];
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://seller.shipyaari.com/angularapi/ondc/sellerRegistration',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_POSTFIELDS =>json_encode($array),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $response = json_decode($response, true);                      
        if($response['message'] == 'Success!'){
           $data = [
            "subscription_amount" => $response['result']['subscription_amount'],
            "plan_title" => $response['result']['plan_title'],
            "login_city" => $response['result']['login_city'],
            "signup_date" => $response['result']['signup_date'],
            "user_id1" => $response['result']['user_id'],
            "enc_user_id" => $response['result']['enc_user_id'],
            "full_name" => $response['result']['full_name'],
            "email" => $response['result']['email'],
            "parent_id" => $response['result']['parent_id'],
            "subscription_plan" => $response['result']['subscription_plan'],
            "mobile" => $response['result']['mobile'],
            "signup_yr" => $response['result']['signup_yr'],
            "sign_up_date" => $response['result']['sign_up_date'],
            "user_type" => $response['result']['user_type'],
            "bap_id" => $response['result']['bap_id'],
           ];
           $user_id = $this->session->userdata('user_id');
           $this->db->where('user_id', $user_id)->update('shipyari_settings', $data);
           $this->response['error'] = false;
           $this->response['csrfName'] = $this->security->get_csrf_token_name();
           $this->response['csrfHash'] = $this->security->get_csrf_hash();
           $this->response['message'] = 'Shipyari account created successfully';
           $this->response['data'] = $response;
        }else{
            $this->response['error'] = true;
            $this->response['csrfName'] = $this->security->get_csrf_token_name();
            $this->response['csrfHash'] = $this->security->get_csrf_hash();
            $this->response['message'] = $response['message'];
            $this->response['data'] = $response;                      
        }
        print_r(json_encode($this->response));
   }
   }

}
