<?php



if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class Financereports extends Admin_Controller

{


    public function __construct()

    {

        parent::__construct();


        $this->time               = strtotime(date('d-m-Y H:i:s'));

        $this->payment_mode       = $this->customlib->payment_mode();

        $this->search_type        = $this->customlib->get_searchtype();

        $this->sch_setting_detail = $this->setting_model->getSetting();

        $this->load->library('media_storage');

        $this->load->model("module_model");

    }

    

    public function finance()

    {  

        $this->session->set_userdata('top_menu', 'Financereports');

        $this->session->set_userdata('sub_menu', 'Financereports/finance');

        $this->session->set_userdata('subsub_menu', '');

        $this->load->view('layout/header');

        $this->load->view('financereports/finance'); 

        $this->load->view('layout/footer');

    }

    

    public function reportduefees()

    {

        if (!$this->rbac->hasPrivilege('balance_fees_statement', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/reportduefees');

        $data                = array();

        $data['title']       = 'student fees';

        $class               = $this->class_model->get();

        $data['classlist']   = $class;

        $data['sch_setting'] = $this->sch_setting_detail;

        if ($this->input->server('REQUEST_METHOD') == "POST") {

            $date               = date('Y-m-d');

            $class_id           = $this->input->post('class_id');

            $section_id         = $this->input->post('section_id');

            $data['class_id']   = $class_id;

            $data['section_id'] = $section_id;

            $fees_dues          = $this->studentfeemaster_model->getStudentDueFeeTypesByDate($date, $class_id, $section_id);

            $students_list      = array();



            if (!empty($fees_dues)) {

                foreach ($fees_dues as $fee_due_key => $fee_due_value) {

                    $amount_paid = 0;



                    if (isJSON($fee_due_value->amount_detail)) {

                        $student_fees_array = json_decode($fee_due_value->amount_detail);

                        foreach ($student_fees_array as $fee_paid_key => $fee_paid_value) {

                            $amount_paid += ($fee_paid_value->amount + $fee_paid_value->amount_discount);

                        }

                    }

                    if ($amount_paid < $fee_due_value->fee_amount || ($amount_paid < $fee_due_value->amount && $fee_due_value->is_system)) {

                        

                        $students_list[$fee_due_value->student_session_id]['admission_no']             = $fee_due_value->admission_no;

                        $students_list[$fee_due_value->student_session_id]['class_id']             = $fee_due_value->class_id;

                        $students_list[$fee_due_value->student_session_id]['section_id']             = $fee_due_value->section_id;

                        $students_list[$fee_due_value->student_session_id]['student_id']             = $fee_due_value->student_id;

                        $students_list[$fee_due_value->student_session_id]['roll_no']                  = $fee_due_value->roll_no;

                        $students_list[$fee_due_value->student_session_id]['admission_date']           = $fee_due_value->admission_date;

                        $students_list[$fee_due_value->student_session_id]['firstname']                = $fee_due_value->firstname;

                        $students_list[$fee_due_value->student_session_id]['middlename']               = $fee_due_value->middlename;

                        $students_list[$fee_due_value->student_session_id]['lastname']                 = $fee_due_value->lastname;

                        $students_list[$fee_due_value->student_session_id]['father_name']              = $fee_due_value->father_name;

                        $students_list[$fee_due_value->student_session_id]['image']                    = $fee_due_value->image;

                        $students_list[$fee_due_value->student_session_id]['mobileno']                 = $fee_due_value->mobileno;

                        $students_list[$fee_due_value->student_session_id]['email']                    = $fee_due_value->email;

                        $students_list[$fee_due_value->student_session_id]['state']                    = $fee_due_value->state;

                        $students_list[$fee_due_value->student_session_id]['city']                     = $fee_due_value->city;

                        $students_list[$fee_due_value->student_session_id]['pincode']                  = $fee_due_value->pincode;

                        $students_list[$fee_due_value->student_session_id]['class']                    = $fee_due_value->class;

                        $students_list[$fee_due_value->student_session_id]['section']                  = $fee_due_value->section;

                        $students_list[$fee_due_value->student_session_id]['fee_groups_feetype_ids'][] = $fee_due_value->fee_groups_feetype_id;

                    }



                }



            }



            if (!empty($students_list)) {

                foreach ($students_list as $student_key => $student_value) {

                    $students_list[$student_key]['fees_list'] = $this->studentfeemaster_model->studentDepositByFeeGroupFeeTypeArray($student_key, $student_value['fee_groups_feetype_ids']);

                   $students_list[$student_key]['transport_fees']       = array();

                $student               = $this->student_model->getByStudentSession($student_value['student_id']);



        $route_pickup_point_id = $student['route_pickup_point_id'];

        $student_session_id    = $student['student_session_id'];

        $transport_fees=[];

                $module=$this->module_model->getPermissionByModulename('transport');



        if($module['is_active']){



        $transport_fees        = $this->studentfeemaster_model->getStudentTransportFees($student_session_id, $route_pickup_point_id);



        }

        $students_list[$student_key]['transport_fees']       = $transport_fees;



                }

            }

 

            $data['student_due_fee'] = $students_list;

        }



        $this->load->view('layout/header', $data);

        $this->load->view('financereports/reportduefees', $data);

        $this->load->view('layout/footer', $data);

    } 

    

    public function printreportduefees()

    {

        $data                = array();

        $data['title']       = 'student fees';

        $class               = $this->class_model->get();

        $data['classlist']   = $class;

        $data['sch_setting'] = $this->sch_setting_detail;

        $date                = date('Y-m-d');

        $class_id            = $this->input->post('class_id');

        $section_id          = $this->input->post('section_id');

        $data['class_id']    = $class_id;

        $data['section_id']  = $section_id;

        $fees_dues           = $this->studentfeemaster_model->getStudentDueFeeTypesByDate($date, $class_id, $section_id);

        $students_list       = array();



        if (!empty($fees_dues)) {

            foreach ($fees_dues as $fee_due_key => $fee_due_value) {

                $amount_paid = 0;



                if (isJSON($fee_due_value->amount_detail)) {

                    $student_fees_array = json_decode($fee_due_value->amount_detail);

                    foreach ($student_fees_array as $fee_paid_key => $fee_paid_value) {

                        $amount_paid += ($fee_paid_value->amount + $fee_paid_value->amount_discount);

                    }

                }

                // if ($amount_paid < $fee_due_value->fee_amount) {

                if ($amount_paid < $fee_due_value->fee_amount || ($amount_paid < $fee_due_value->amount && $fee_due_value->is_system)) {

                    $students_list[$fee_due_value->student_session_id]['admission_no']             = $fee_due_value->admission_no;

                     $students_list[$fee_due_value->student_session_id]['class_id']             = $fee_due_value->class_id;

                        $students_list[$fee_due_value->student_session_id]['section_id']             = $fee_due_value->section_id;

                        $students_list[$fee_due_value->student_session_id]['student_id']             = $fee_due_value->student_id;

                    $students_list[$fee_due_value->student_session_id]['roll_no']                  = $fee_due_value->roll_no;

                    $students_list[$fee_due_value->student_session_id]['admission_date']           = $fee_due_value->admission_date;

                    $students_list[$fee_due_value->student_session_id]['firstname']                = $fee_due_value->firstname;

                    $students_list[$fee_due_value->student_session_id]['middlename']               = $fee_due_value->middlename;

                    $students_list[$fee_due_value->student_session_id]['lastname']                 = $fee_due_value->lastname;

                    $students_list[$fee_due_value->student_session_id]['father_name']              = $fee_due_value->father_name;

                    $students_list[$fee_due_value->student_session_id]['image']                    = $fee_due_value->image;

                    $students_list[$fee_due_value->student_session_id]['mobileno']                 = $fee_due_value->mobileno;

                    $students_list[$fee_due_value->student_session_id]['email']                    = $fee_due_value->email;

                    $students_list[$fee_due_value->student_session_id]['state']                    = $fee_due_value->state;

                    $students_list[$fee_due_value->student_session_id]['city']                     = $fee_due_value->city;

                    $students_list[$fee_due_value->student_session_id]['pincode']                  = $fee_due_value->pincode;

                    $students_list[$fee_due_value->student_session_id]['class']                    = $fee_due_value->class;

                    $students_list[$fee_due_value->student_session_id]['section']                  = $fee_due_value->section;

                    $students_list[$fee_due_value->student_session_id]['fee_groups_feetype_ids'][] = $fee_due_value->fee_groups_feetype_id;

                }

            }

        }



        if (!empty($students_list)) {

            foreach ($students_list as $student_key => $student_value) {

                $students_list[$student_key]['fees_list'] = $this->studentfeemaster_model->studentDepositByFeeGroupFeeTypeArray($student_key, $student_value['fee_groups_feetype_ids']);

                  $students_list[$student_key]['transport_fees']       = array();

                $student               = $this->student_model->getByStudentSession($student_value['student_id']);



        $route_pickup_point_id = $student['route_pickup_point_id'];

        $student_session_id    = $student['student_session_id'];

        $transport_fees=[];

                $module=$this->module_model->getPermissionByModulename('transport');



        if($module['is_active']){



        $transport_fees        = $this->studentfeemaster_model->getStudentTransportFees($student_session_id, $route_pickup_point_id);



        }

        $students_list[$student_key]['transport_fees']       = $transport_fees;

            }

        }

        $data['student_due_fee'] = $students_list;

        $page                    = $this->load->view('financereports/_printreportduefees', $data, true);

        echo json_encode(array('status' => 1, 'page' => $page));

    }

    

    public function reportdailycollection()

    {

        if (!$this->rbac->hasPrivilege('daily_collection_report', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/reportdailycollection');

        $data          = array();

        $data['title'] = 'Daily Collection Report';

        $this->form_validation->set_rules('date_from', $this->lang->line('date_from'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('date_to', $this->lang->line('date_to'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == true) {



            $date_from          = $this->input->post('date_from');

            $date_to            = $this->input->post('date_to');

            $formated_date_from = strtotime($this->customlib->dateFormatToYYYYMMDD($date_from));

            $formated_date_to   = strtotime($this->customlib->dateFormatToYYYYMMDD($date_to));

            $st_fees            = $this->studentfeemaster_model->getCurrentSessionStudentFees();

            $fees_data          = array();



            for ($i = $formated_date_from; $i <= $formated_date_to; $i += 86400) {

                $fees_data[$i]['amt']                       = 0;

                $fees_data[$i]['count']                     = 0;

                $fees_data[$i]['student_fees_deposite_ids'] = array();

            }



            if (!empty($st_fees)) {

                foreach ($st_fees as $fee_key => $fee_value) {

                    if (isJSON($fee_value->amount_detail)) {

                        $fees_details = (json_decode($fee_value->amount_detail));

                        if (!empty($fees_details)) {

                            foreach ($fees_details as $fees_detail_key => $fees_detail_value) {

                                $date = strtotime($fees_detail_value->date);

                                if ($date >= $formated_date_from && $date <= $formated_date_to) {

                                    if (array_key_exists($date, $fees_data)) {

                                        $fees_data[$date]['amt'] += $fees_detail_value->amount + $fees_detail_value->amount_fine;
                                        
                                        $fees_data[$date]['bycash'] += ($fees_detail_value->payment_mode == "Cash") ? ($fees_detail_value->amount + $fees_detail_value->amount_fine) : 0;
                                        
                                        $fees_data[$date]['byothers'] += ($fees_detail_value->payment_mode != "Cash") ? $fees_detail_value->amount + $fees_detail_value->amount_fine : 0;

                                        $fees_data[$date]['count'] += 1;

                                        $fees_data[$date]['student_fees_deposite_ids'][] = $fee_value->student_fees_deposite_id;

                                    } else {

                                        $fees_data[$date]['amt']                         = $fees_detail_value->amount + $fees_detail_value->amount_fine;
                                        
                                        $fees_data[$date]['bycash'] += ($fees_detail_value->payment_mode == "Cash") ? ($fees_detail_value->amount + $fees_detail_value->amount_fine) : 0;
                                        
                                        $fees_data[$date]['byothers'] += ($fees_detail_value->payment_mode != "Cash") ? $fees_detail_value->amount + $fees_detail_value->amount_fine : 0;

                                        $fees_data[$date]['count']                       = 1;

                                        $fees_data[$date]['student_fees_deposite_ids'][] = $fee_value->student_fees_deposite_id;

                                    }

                                }

                            }

                        }

                    }

                }

            }

            $data['fees_data'] = $fees_data;



        }



        $this->load->view('layout/header', $data);

        $this->load->view('financereports/reportdailycollection', $data);

        $this->load->view('layout/footer', $data);

    }

    

    public function feeCollectionStudentDeposit()

    {

        $data                 = array();

        $date                 = $this->input->post('date');

        $fees_id              = $this->input->post('fees_id');

        $fees_id_array        = explode(',', $fees_id);

        $fees_list            = $this->studentfeemaster_model->getFeesDepositeByIdArray($fees_id_array);

        $data['student_list'] = $fees_list;

        $data['date']         = $date;

        $data['sch_setting']  = $this->sch_setting_detail;

        $page                 = $this->load->view('financereports/_feeCollectionStudentDeposit', $data, true);

        echo json_encode(array('status' => 1, 'page' => $page));

    }

    

    public function reportbyname()

    {

        if (!$this->rbac->hasPrivilege('fees_statement', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/reportbyname');

        $data['title']       = 'student fees';

        $data['title']       = 'student fees';

        $class               = $this->class_model->get();

        $data['classlist']   = $class;

        $data['sch_setting'] = $this->sch_setting_detail;



        if ($this->input->server('REQUEST_METHOD') == "GET") {

            $this->load->view('layout/header', $data);

            $this->load->view('financereports/reportByName', $data);

            $this->load->view('layout/footer', $data);

        } else {

            {

                $data['student_due_fee'] = array();

                $class_id                = $this->input->post('class_id');

                $section_id              = $this->input->post('section_id');

                $student_id              = $this->input->post('student_id');

                $student_due_fee         = $this->studentfeemaster_model->getStudentFeesByClassSectionStudent($class_id, $section_id, $student_id);

                foreach($student_due_fee as $key=>$value){

                    $transport_fees=array();

                  $student               = $this->student_model->getByStudentSession($value['student_id']);



        $route_pickup_point_id = $student['route_pickup_point_id'];

        $student_session_id    = $student['student_session_id'];

        $transport_fees=[];

                $module=$this->module_model->getPermissionByModulename('transport');

 

        if($module['is_active']){



        $transport_fees        = $this->studentfeemaster_model->getStudentTransportFees($student_session_id, $route_pickup_point_id);



        }

        $student_due_fee[$key]['transport_fees']         = $transport_fees;  

                }

                

      

                $data['student_due_fee'] = $student_due_fee;

                $data['class_id']        = $class_id;

                $data['section_id']      = $section_id;

                $data['student_id']      = $student_id;

                $category                = $this->category_model->get();

                $data['categorylist']    = $category;

                $this->load->view('layout/header', $data);

                $this->load->view('financereports/reportByName', $data);

                $this->load->view('layout/footer', $data);

            }

        }

    }

     

    public function studentacademicreport()

    {

        if (!$this->rbac->hasPrivilege('balance_fees_report', 'can_view')) {

            access_denied();

        }



        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/studentacademicreport');

        $data['title']           = 'student fee';

        $data['payment_type']    = $this->customlib->getPaymenttype();

        $class                   = $this->class_model->get();

        $data['classlist']       = $class;

        $data['sch_setting']     = $this->sch_setting_detail;

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $data['student_due_fee'] = array();

            $data['resultarray']     = array();

            $data['feetype']     = "";

            $data['feetype_arr'] = array();

        } else {

            $student_Array = array();

            $search_type   = $this->input->post('search_type');

            $class_id   = $this->input->post('class_id');

            $section_id = $this->input->post('section_id');



            if (isset($class_id)) {

                $studentlist = $this->student_model->searchByClassSectionWithSession($class_id, $section_id);

            } else {

                $studentlist = $this->student_model->getStudents();

            }



            $student_Array = array();

if (!empty($studentlist)) {

                foreach ($studentlist as $key => $eachstudent) {

                    $obj                = new stdClass();

                    $obj->name          = $this->customlib->getFullName($eachstudent['firstname'], $eachstudent['middlename'], $eachstudent['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);

                    $obj->class         = $eachstudent['class'];

                    $obj->section       = $eachstudent['section'];

                    $obj->admission_no  = $eachstudent['admission_no'];

                    $obj->roll_no       = $eachstudent['roll_no'];

                    $obj->father_name   = $eachstudent['father_name'];

                    $student_session_id = $eachstudent['student_session_id'];

                    $student_total_fees = $this->studentfeemaster_model->getTransStudentFees($student_session_id); 



                    if (!empty($student_total_fees)) {

                        $totalfee = 0;

                        $deposit  = 0;

                        $discount = 0;

                        $balance  = 0;

                        $fine     = 0;
                        
                        $t_due_bal     = 0;
                        
                        $temp_total     = 0;
                        
                        $temp_total1     = 0;
                        
                        $pamount     = 0;
                        
                        $pdiscount     = 0;

                          //print_r($student_total_fees);die;

                        foreach ($student_total_fees as $student_total_fees_key => $student_total_fees_value) {



                            if (!empty($student_total_fees_value->fees)) {

                                foreach ($student_total_fees_value->fees as $each_fee_key => $each_fee_value) {
                                        
                                        $temp_total     = 0;
    
                                        $totalfee = $totalfee +$each_fee_value->amount;
                                        
                                         $temp_total     = $each_fee_value->amount;

                                  
                                        $amount_detail =json_decode($each_fee_value->amount_detail);

                                   


                                    if (is_object($amount_detail) && !empty($amount_detail)) {

                                        foreach ($amount_detail as $amount_detail_key => $amount_detail_value) {

                                            $deposit  = $deposit + $amount_detail_value->amount;

                                            $fine     = $fine + $amount_detail_value->amount_fine;

                                            $discount = $discount + $amount_detail_value->amount_discount;
                                            
                                            $temp_total -= ($amount_detail_value->amount + $amount_detail_value->amount_discount);

                                        }

                                    }
                                    
                                    // due fee section
                                    
                                    
                                 if ( (strtotime($each_fee_value->due_date) < strtotime(date('Y-m-d')))  && (($amount_detail) == 0 || !empty($amount_detail))) {
                                   
                                        $temp_total1   += $temp_total;
                            
                                    }
                                   
                                }

                            }

                        }



                        
                        $obj->totalfee     = $totalfee;

                        $obj->payment_mode = "N/A";

                        $obj->deposit      = $deposit;

                        $obj->fine         = $fine;

                        $obj->discount     = $discount;

                        $obj->balance      = $totalfee - ($deposit + $discount);
                        
                       
                        
                        $obj->t_due_bal      = $temp_total1;
                        

                    } else {



                        $obj->totalfee     = 0;

                        $obj->payment_mode = 0;

                        $obj->deposit      = 0;

                        $obj->fine         = 0;

                        $obj->balance      = 0;

                        $obj->discount     = 0;
                        
                        $obj->t_due_bal     = 0;

                    }



                    if ($search_type == 'all') {

                        $student_Array[] = $obj;

                    } elseif ($search_type == 'balance') {

                        if ($obj->t_due_bal > 0) {

                            $student_Array[] = $obj;

                        }

                    } elseif ($search_type == 'paid') {

                        if ($obj->t_due_bal <= 0) {

                            $student_Array[] = $obj;

                        }

                    }

                }

            }



            $classlistdata[]         = array('result' => $student_Array);

            $data['student_due_fee'] = $student_Array;

            $data['resultarray']     = $classlistdata;



        }



        $this->load->view('layout/header', $data);

        $this->load->view('financereports/studentAcademicReport', $data);

        $this->load->view('layout/footer', $data);

    }

    // public function studentacademicreport()

    // {

    //     if (!$this->rbac->hasPrivilege('balance_fees_report', 'can_view')) {

    //         access_denied();

    //     }



    //     $this->session->set_userdata('top_menu', 'Reports');

    //     $this->session->set_userdata('sub_menu', 'Reports/finance');

    //     $this->session->set_userdata('subsub_menu', 'Reports/finance/studentacademicreport');

    //     $data['title']           = 'student fee';

    //     $data['payment_type']    = $this->customlib->getPaymenttype();

    //     $class                   = $this->class_model->get();

    //     $data['classlist']       = $class;

    //     $data['sch_setting']     = $this->sch_setting_detail;

    //     $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

    //     $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



    //     if ($this->form_validation->run() == false) {

    //         $data['student_due_fee'] = array();

    //         $data['resultarray']     = array();

    //         $data['feetype']     = "";

    //         $data['feetype_arr'] = array();

    //     } else {

    //         $student_Array = array();

    //         $search_type   = $this->input->post('search_type');

    //         $class_id   = $this->input->post('class_id');

    //         $section_id = $this->input->post('section_id');



    //         if (isset($class_id)) {

    //             $studentlist = $this->student_model->searchByClassSectionWithSession($class_id, $section_id);

    //         } else {

    //             $studentlist = $this->student_model->getStudents();

    //         }



    //         $student_Array = array();

    //         if (!empty($studentlist)) {

    //             foreach ($studentlist as $key => $eachstudent) {

    //                 $obj                = new stdClass();

    //                 $obj->name          = $this->customlib->getFullName($eachstudent['firstname'], $eachstudent['middlename'], $eachstudent['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);

    //                 $obj->class         = $eachstudent['class'];

    //                 $obj->section       = $eachstudent['section'];

    //                 $obj->admission_no  = $eachstudent['admission_no'];

    //                 $obj->roll_no       = $eachstudent['roll_no'];

    //                 $obj->father_name   = $eachstudent['father_name'];

    //                 $student_session_id = $eachstudent['student_session_id'];

    //                 $student_total_fees = $this->studentfeemaster_model->getTransStudentFees($student_session_id); 



    //                 if (!empty($student_total_fees)) {

    //                     $totalfee = 0;

    //                     $deposit  = 0;

    //                     $discount = 0;

    //                     $balance  = 0;

    //                     $fine     = 0;

    //                       //print_r($student_total_fees);die;

    //                     foreach ($student_total_fees as $student_total_fees_key => $student_total_fees_value) {



    //                         if (!empty($student_total_fees_value->fees)) {

    //                             foreach ($student_total_fees_value->fees as $each_fee_key => $each_fee_value) {

                                

    //                                     $totalfee = $totalfee +$each_fee_value->amount;

                                  

                                    

    //                                     $amount_detail =json_decode($each_fee_value->amount_detail);

                                   

                                   



    //                                 if (is_object($amount_detail) && !empty($amount_detail)) {

    //                                     foreach ($amount_detail as $amount_detail_key => $amount_detail_value) {

    //                                         $deposit  = $deposit + $amount_detail_value->amount;

    //                                         $fine     = $fine + $amount_detail_value->amount_fine;

    //                                         $discount = $discount + $amount_detail_value->amount_discount;

    //                                     }

    //                                 }

    //                             }

    //                         }

    //                     }



    //                     $obj->totalfee     = $totalfee;

    //                     $obj->payment_mode = "N/A";

    //                     $obj->deposit      = $deposit;

    //                     $obj->fine         = $fine;

    //                     $obj->discount     = $discount;

    //                     $obj->balance      = $totalfee - ($deposit + $discount);

    //                 } else {



    //                     $obj->totalfee     = 0;

    //                     $obj->payment_mode = 0;

    //                     $obj->deposit      = 0;

    //                     $obj->fine         = 0;

    //                     $obj->balance      = 0;

    //                     $obj->discount     = 0;

    //                 }



    //                 if ($search_type == 'all') {

    //                     $student_Array[] = $obj;

    //                 } elseif ($search_type == 'balance') {

    //                     if ($obj->balance > 0) {

    //                         $student_Array[] = $obj;

    //                     }

    //                 } elseif ($search_type == 'paid') {

    //                     if ($obj->balance <= 0) {

    //                         $student_Array[] = $obj;

    //                     }

    //                 }

    //             }

    //         }



    //         $classlistdata[]         = array('result' => $student_Array);

    //         $data['student_due_fee'] = $student_Array;

    //         $data['resultarray']     = $classlistdata;



    //     }



    //     $this->load->view('layout/header', $data);

    //     $this->load->view('financereports/studentAcademicReport', $data);

    //     $this->load->view('layout/footer', $data);

    // }

    

    public function collection_report()

    {

        // file_put_contents('cancelq_check.txt',$_POST['cancel_check']);

        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {

            access_denied();

        }
      
       $isChecked = '0';
       $discIsChecked = '0';
       $finediscIsChecked = '0';
        
        $data['collect_by']  = $this->studentfeemaster_model->get_feesreceived_by();

        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['group_by']    = $this->customlib->get_groupby();

        $feetype             = $this->feetype_model->get();

        $tnumber=count($feetype);

        $feetype[$tnumber]=array('id'=>'transport_fees','type'=>'Transport Fees');

        
        $data['feetypeList'] = $feetype;

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/collection_report');

        $subtotal = false;

        

        if (isset($_POST['search_type']) && $_POST['search_type'] != '') {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        } else {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        }



        if (isset($_POST['collect_by']) && $_POST['collect_by'] != '') {

            $data['received_by'] = $received_by = $_POST['collect_by'];

        } else {

            $data['received_by'] = $received_by = '';

        }



        if (isset($_POST['feetype_id']) && $_POST['feetype_id'] != '') {

            $feetype_id = $_POST['feetype_id'];

        } else {

            $feetype_id = "";

        }


        if (isset($_POST['group']) && $_POST['group'] != '') {

            $data['group_byid'] = $group = $_POST['group'];

            $subtotal           = true;

        } else {

            $data['group_byid'] = $group = '';

        }
        
         // Check if the checkbox is checked
        if (isset($_POST['cancel_check']) && $_POST['cancel_check'] == '1') {
            $isChecked = $_POST['ischecked'];
            $isChecked = '1';
        }else{
            $isChecked = '0';
        }
        
         // Check if the checkbox is checked
        if (isset($_POST['discounted_fee_check']) && $_POST['discounted_fee_check'] == '1') {
            $discIsChecked = $_POST['discounted_fee_check'];
            $discIsChecked = '1';
        }else{
            $discIsChecked = '0';
        }
        
         // Check if the checkbox is checked
        if (isset($_POST['fine_discounted_fee_check']) && $_POST['fine_discounted_fee_check'] == '1') {
            $finediscIsChecked = $_POST['fine_discounted_fee_check'];
            $finediscIsChecked = '1';
        }else{
            $finediscIsChecked = '0';
        }

         $data['ischecked'] = $isChecked;
         
         $data['discIsChecked'] = $discIsChecked;
         
         
         $data['finediscIsChecked'] = $finediscIsChecked;


        $collect_by = array();

        $collection = array();

        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $this->form_validation->set_rules('search_type', $this->lang->line('search_duration'), 'trim|required|xss_clean');


        $data['classlist']        = $this->class_model->get();

        $data['selected_section'] = '';



        if ($this->form_validation->run() == false) {

            $data['results'] = array();

        } else {



            $class_id   = $this->input->post('class_id');

            $section_id = $this->input->post('section_id');

            $data['selected_section'] = $section_id;
            

            $data['results'] = $this->studentfeemaster_model->getFeeCollectionReport($start_date, $end_date, $feetype_id, $received_by, $group, $class_id, $section_id, $isChecked, $discIsChecked);
            // print_r($data['results']); exit();


            if ($group != '') {


                if ($group == 'class') {

                    $group_by = 'class_id';

                } elseif ($group == 'collection') {

                    $group_by = 'received_by';

                } elseif ($group == 'mode' && $this->input->post('paymode') != '') {

                    $group_by = 'payment_mode';
                    
                    $pay_mode = $this->input->post('paymode');
                    
                    $data['pay_mode'] = $pay_mode;
                    
                    // ============= beginning of the modificaion ===================
                    // Added by Hussain on 20_08_2024
                    
                    $modes = explode(",",$pay_mode);
                    
                    $filtered = $this->filter_payment_mode1($data['results'], $modes);
                    
                    
                    // === end of the modification================================
                    
                    // $filtered = $this->filter_payment_mode($data['results'], $pay_mode);
                    
                    foreach ($filtered as $key => $value) {
                        
                        $collection[$value[$group_by]][] = $value;
                        
                    }

                }

                if ($group != 'mode' || ($group == 'mode' && $this->input->post('paymode') == '')) {
                    
                    foreach ($data['results'] as $key => $value) {
                        
                        $collection[$value[$group_by]][] = $value;
                        
                    }
                }
                
            } else {

                $s = 0;

                foreach ($data['results'] as $key => $value) {

                    $collection[$s++] = array($value);

                }

            }
            
            $collection1 =array();
            if($finediscIsChecked == "1"){
                
                 $filtered = $this->filter_fine_discount($collection, "fine_dicount");
                 
                        foreach ($filtered as $key => $value) {
                            if(isset($group) && !empty($group)){
                                // $collection1[$value[$group_by]][] = $value;
                                $collection1[$s++] = $value;
                            }else{
                                
                                $collection1[$s++] = $value;
                            }
                            
                        }
                        $collection = $collection1;
            }
            
        }

        $data['results'] = $collection;

        $data['subtotal']    = $subtotal;

        

        $data['sch_setting'] = $this->sch_setting_detail;

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/collection_report', $data);

        $this->load->view('layout/footer', $data);

    }
    
    
    function filter_payment_mode($feeArr, $mode){
        
        $filered_fees = array();
        
        foreach($feeArr as $key => $feeList){
            
             $paidMode = $feeList["payment_mode"];
                 
             if($mode == $paidMode){
                            
                 $filered_fees[] = $feeList;
                }
        
            
        }
         return $filered_fees;
    }
    function filter_payment_mode1($feeArr, $modes){
        
        $filered_fees = array();
        
        // print_r($feeArr); exit();
        if(is_array($modes)){
            foreach($modes as $modekey => $modeVal){
                
                foreach($feeArr as $key => $feeList){
                     $paidMode = $feeList["payment_mode"];
                    // echo (trim($modeVal) == trim($paidMode))? $modeVal."========================+".$paidMode."=> Match\n" : $modeVal."========================+".$paidMode." Not match \n";
                         $Str1 = trim($modeVal);
                         $str2 = trim($paidMode);
                     if(strtolower($Str1) == strtolower($str2)){
                                    
                           $filered_fees[] = $feeList;
                        }
                
                    
                }
                
            }
        
        }
        
        // print_r($filered_fees); exit();
         return $filered_fees;
    }
    
    function filter_fine_discount($feeArr, $fine_discount){
        
        $filered_fees = array();
        
        foreach($feeArr as $key => $feeList){
            
             $paidfdiscount = isset($feeList[0]["fine_discount"]) ? $feeList[0]["fine_discount"]: 0;
             
             if($paidfdiscount > 0){
                            
                 $filered_fees[] = $feeList;
                }
        
            
        }
         return $filered_fees;
    }
    
    
    // function filter_payment_mode($feeArr, $mode){
        
    //     $filered_fees = array();
        
    //     foreach($feeArr as $key => $feeList){
            
    //         if (!empty($feeList->amount_detail)) {

    //                 $fee_deposits = json_decode(($feeList->amount_detail));
                    
    //                 foreach ($fee_deposits as $fee_deposits_key => $fee_deposits_value) {
    //                     print_r($fee_deposits_value); exit();
    //                     // $paidMode = $fee_deposits_value[mode];
    //                     if($mode == $paidMode){
                            
    //                         $filered_fees[count($filered_fees)-1] = $fee_deposits_value;
    //                     }
                        
    //                 }
    //         }
            
    //     }
    //      return $filered_fees;
    // }
    
    

    

    public function onlinefees_report()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/onlinefees_report');

        $data['searchlist'] = $this->customlib->get_searchtype();

        $data['group_by']   = $this->customlib->get_groupby();



        if (isset($_POST['search_type']) && $_POST['search_type'] != '') {



            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        } else {



            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        }



        $collection = array();

        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));

        $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $data['collectlist'] = array();

        } else {

            $data['collectlist'] = $this->studentfeemaster_model->getOnlineFeeCollectionReport($start_date, $end_date);

        }

 

        $data['sch_setting'] = $this->sch_setting_detail;

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/onlineFeesReport', $data);

        $this->load->view('layout/footer', $data);

    }

    

    public function duefeesremark()

    { 

        if (!$this->rbac->hasPrivilege('balance_fees_report_with_remark', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/duefeesremark');

        $data                = array();

        $data['title']       = 'student fees';

        $class               = $this->class_model->get();

        $data['classlist']   = $class;

        $data['sch_setting'] = $this->sch_setting_detail;

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == true) {

            $date               = date('Y-m-d');

            $class_id           = $this->input->post('class_id');

            $section_id         = $this->input->post('section_id');

            $data['class_id']   = $class_id;

            $data['section_id'] = $section_id;

            $date               = date('Y-m-d');

            $student_due_fee    = $this->studentfee_model->getDueStudentFeesByDateClassSection($class_id, $section_id, $date);

            $students = array();

            if (!empty($student_due_fee)) {

                foreach ($student_due_fee as $student_due_fee_key => $student_due_fee_value) {



                    $amt_due = ($student_due_fee_value['is_system']) ? $student_due_fee_value['previous_balance_amount'] : $student_due_fee_value['amount'];

                    

                       $a = json_decode($student_due_fee_value['amount_detail']); 

                    

                  

                    if (!empty($a)) {

                        $amount          = 0;

                        $amount_discount = 0;

                        $amount_fine     = 0;



                        foreach ($a as $a_key => $a_value) {

                            $amount          = $amount + $a_value->amount;

                            $amount_discount = $amount_discount + $a_value->amount_discount;

                            $amount_fine     = $amount_fine + $a_value->amount_fine;

                        }

                        if ($amt_due <= ($amount + $amount_discount)) {

                            unset($student_due_fee[$student_due_fee_key]);

                        } else {



                            if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {

                                $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);

                            }



                            $students[$student_due_fee_value['student_session_id']]['fees'][] = array(

                                'is_system'=>$student_due_fee_value['is_system'],

                                'amount'          => $amt_due,

                                'amount_deposite' => $amount,

                                'amount_discount' => $amount_discount,

                                'amount_fine'     => $amount_fine,

                                'fee_group'       => $student_due_fee_value['fee_group'],

                                'fee_type'        => $student_due_fee_value['fee_type'],

                                'fee_code'        => $student_due_fee_value['fee_code'],



                            );

                           

                        }

                    } else {

                        $amount          = 0;

                        $amount_discount = 0;

                        

                        if ($amt_due <= ($amount + $amount_discount)) {

                            unset($student_due_fee[$student_due_fee_key]);

                        } else {

                            if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {



                                $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);

                            }

                            $students[$student_due_fee_value['student_session_id']]['fees'][] = array(

                                'is_system'=>$student_due_fee_value['is_system'],

                                'amount'          => $amt_due,

                                'amount_deposite' => 0,

                                'amount_discount' => 0,

                                'amount_fine'     => 0,

                                'fee_group'       => $student_due_fee_value['fee_group'],

                                'fee_type'        => $student_due_fee_value['fee_type'],

                                'fee_code'        => $student_due_fee_value['fee_code'],

                            );

                            

                        }

                    }

                    

                  

                }



            }



            $data['student_remain_fees'] = $students;



        }

  $data['start_month'] = $this->sch_setting_detail->start_month;

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/duefeesremark', $data);

        $this->load->view('layout/footer', $data);

    }

    

    public function add_new_student($student)

    {

        $new_student = array(

            'id'                 => $student['id'],

            'student_session_id' => $student['student_session_id'],

            'class'              => $student['class'],

            'section_id'         => $student['section_id'],

            'section'            => $student['section'],

            'admission_no'       => $student['admission_no'],

            'roll_no'            => $student['roll_no'],

            'admission_date'     => $student['admission_date'],

            'firstname'          => $student['firstname'],

            'middlename'         => $student['middlename'],

            'lastname'           => $student['lastname'],

            'image'              => $student['image'],

            'mobileno'           => $student['mobileno'],

            'email'              => $student['email'],

            'state'              => $student['state'],

            'city'               => $student['city'],

            'pincode'            => $student['pincode'],

            'religion'           => $student['religion'],

            'dob'                => $student['dob'],

            'current_address'    => $student['current_address'],

            'permanent_address'  => $student['permanent_address'],

            'category_id'        => $student['category_id'],

            'category'           => $student['category'],

            'adhar_no'           => $student['adhar_no'],

            'samagra_id'         => $student['samagra_id'],

            'bank_account_no'    => $student['bank_account_no'],

            'bank_name'          => $student['bank_name'],

            'ifsc_code'          => $student['ifsc_code'],

            'guardian_name'      => $student['guardian_name'],

            'guardian_relation'  => $student['guardian_relation'],

            'guardian_phone'     => $student['guardian_phone'],

            'guardian_address'   => $student['guardian_address'],

            'is_active'          => $student['is_active'],

            'father_name'        => $student['father_name'],

            'rte'                => $student['rte'],

            'gender'             => $student['gender'],



        );

        return $new_student;

    }

    

    public function printduefeesremark()

    {

        if (!$this->rbac->hasPrivilege('fees_statement', 'can_view')) {

            access_denied();

        }



        $date                = date('Y-m-d');

        $class_id            = $this->input->post('class_id');

        $section_id          = $this->input->post('section_id');

        $data['class_id']    = $class_id;

        $data['section_id']  = $section_id;

        $data['class']       = $this->class_model->get($class_id);

        $data['section']     = $this->section_model->get($section_id);

        $date                = date('Y-m-d');

        $data['sch_setting'] = $this->sch_setting_detail;

        $student_due_fee     = $this->studentfee_model->getDueStudentFeesByDateClassSection($class_id, $section_id, $date);



        $students = array();



        if (!empty($student_due_fee)) {

            foreach ($student_due_fee as $student_due_fee_key => $student_due_fee_value) {



              



                $amt_due = ($student_due_fee_value['is_system']) ? $student_due_fee_value['previous_balance_amount'] : $student_due_fee_value['amount'];



                $a = json_decode($student_due_fee_value['amount_detail']);

                if (!empty($a)) {

                    $amount          = 0;

                    $amount_discount = 0;

                    $amount_fine     = 0;



                    foreach ($a as $a_key => $a_value) {

                        $amount          = $amount + $a_value->amount;

                        $amount_discount = $amount_discount + $a_value->amount_discount;

                        $amount_fine     = $amount_fine + $a_value->amount_fine;

                    }

                    if ($amt_due <= ($amount + $amount_discount)) {

                        unset($student_due_fee[$student_due_fee_key]);

                    } else {



                        if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {

                            $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);

                        }



                        $students[$student_due_fee_value['student_session_id']]['fees'][] = array(

                            'is_system'=>$student_due_fee_value['is_system'],

                            'amount'          => $amt_due,

                            'amount_deposite' => $amount,

                            'amount_discount' => $amount_discount,

                            'amount_fine'     => $amount_fine,

                            'fee_group'       => $student_due_fee_value['fee_group'],

                            'fee_type'        => $student_due_fee_value['fee_type'],

                            'fee_code'        => $student_due_fee_value['fee_code'],

                        );



                    }

                } else {

                    $amount          = 0;

                    $amount_discount = 0;



                    if ($amt_due <= ($amount + $amount_discount)) {

                        unset($student_due_fee[$student_due_fee_key]);

                    } else {

                        if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {

                            $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);

                        }

                        $students[$student_due_fee_value['student_session_id']]['fees'][] = array(

                            'is_system'=>$student_due_fee_value['is_system'],

                            'amount'          => $amt_due,

                            'amount_deposite' => 0,

                            'amount_discount' => 0,

                            'amount_fine'     => 0,

                            'fee_group'       => $student_due_fee_value['fee_group'],

                            'fee_type'        => $student_due_fee_value['fee_type'],

                            'fee_code'        => $student_due_fee_value['fee_code'],

                        );

                    }

                }

            }

        }



        $data['student_remain_fees'] = $students;

        $page = $this->load->view('financereports/_printduefeesremark', $data, true);

        echo json_encode(array('status' => 1, 'page' => $page));



    }

    

    public function income()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/income');

        $data['searchlist'] = $this->customlib->get_searchtype();

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/income', $data);

        $this->load->view('layout/footer', $data);

    }   



    public function vouchersearchreportvalidation()

    {

        $this->form_validation->set_rules('exp_voucher_no', $this->lang->line('exp_voucher_no'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $error = array();

            $error['exp_voucher_no'] = form_error('exp_voucher_no');


            $array = array('status' => 0, 'error' => $error);

            echo json_encode($array);

        } else {

            $exp_voucher_no = $this->input->post('exp_voucher_no');

            $params = array('exp_voucher_no' => $exp_voucher_no);

            $array  = array('status' => 1, 'error' => '', 'params' => $params);

            echo json_encode($array);

        }

    }
    
    
    public function cancelsearchreportvalidation()

    {
        
        $this->form_validation->set_rules('search_type', $this->lang->line('error_search_type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

            $error = array();

            $error['search_type'] = form_error('search_type');


            $array = array('status' => 0, 'error' => $error);

            echo json_encode($array);

        } else {

            $search_type = $this->input->post('search_type');
            
             $date_from   = "";

            $date_to     = "";
            
            
            if ($search_type == 'period') {



                $date_from = $this->input->post('date_from');

                $date_to   = $this->input->post('date_to');

            }
            

            // $params = array('search_type' => $search_type);
            $params = array('search_type' => $search_type, 'date_from' => $date_from, 'date_to' => $date_to);

            $array  = array('status' => 1, 'error' => '', 'params' => $params);

            echo json_encode($array);

        }

    }

    

    public function searchreportvalidation()

    {


        $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $error = array();

            $error['search_type'] = form_error('search_type');

            $array = array('status' => 0, 'error' => $error);

            echo json_encode($array);

        } else {

            $search_type = $this->input->post('search_type');

            $date_from   = "";

            $date_to     = "";

            if ($search_type == 'period') {



                $date_from = $this->input->post('date_from');

                $date_to   = $this->input->post('date_to');

            }


            $expense_mode = $this->input->post('expense_mode');

            // $params = array('exp_voucher_no' => $exp_voucher_no, 'expense_mode' => $expense_mode);

            $params = array('search_type' => $search_type, 'date_from' => $date_from, 'date_to' => $date_to, 'expense_mode' => $expense_mode);

            $array  = array('status' => 1, 'error' => '', 'params' => $params);

            echo json_encode($array);

        }

    }

    

    public function getincomelistbydt()

    {

        $search_type = $this->input->post('search_type');

        $date_from   = $this->input->post('date_from');

        $date_to     = $this->input->post('date_to');



        if ($search_type == "") {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        } else {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        }



        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));



        $incomeList = $this->income_model->search("", $start_date, $end_date);



        $incomeList      = json_decode($incomeList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($incomeList->data)) {

            foreach ($incomeList->data as $key => $value) {

                $grand_total += $value->amount;



                $row   = array();

                $row[] = $value->name;

                $row[] = $value->invoice_no;

                $row[] = $value->income_category;

                $row[] = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                $row[] = $currency_symbol . amountFormat($value->amount);

                $dt_data[] = $row;

            }

            $footer_row   = array();

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "<b>" . $this->lang->line('grand_total') . "</b>";

            $footer_row[] = $currency_symbol . amountFormat($grand_total);

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($incomeList->draw),

            "recordsTotal"    => intval($incomeList->recordsTotal),

            "recordsFiltered" => intval($incomeList->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);



    }

    

    public function expense()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/expense');

        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['date_type']   = $this->customlib->date_type();

        $data['date_typeid'] = '';



        $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        } else {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        }



        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/expense', $data);

        $this->load->view('layout/footer', $data);

    }

    public function voucher($voucherno=null)
    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/voucher');



        $this->form_validation->set_rules('exp_voucher_no', $this->lang->line('exp_voucher_no'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['exp_voucher_no'] = '';

        } else {

            $data['exp_voucher_no'] = $_POST['exp_voucher_no'];

        }


        // $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/voucher', $data);

        $this->load->view('layout/footer', $data);

    }


    public function cancelfee($cancefee=null)
    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/cancelfee');


        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['date_type']   = $this->customlib->date_type();
        
        
        


        $this->form_validation->set_rules('receipt_no', $this->lang->line('receipt_no'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['receipt_no'] = '';

        } else {

            $data['receipt_no'] = $_POST['receipt_no'];

        }


        // $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/cancelfee', $data);

        $this->load->view('layout/footer', $data);

    }

    

    public function getexpenselistbydt()

    {

        $search_type   = $this->input->post('search_type');

        $date_from     = $this->input->post('date_from');

        $date_to       = $this->input->post('date_to');

        $voucherNo     = $this->input->post('exp_voucher_no');
        
        $expense_mode  = $this->input->post('expense_mode');



        if ($search_type == "") {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        } else {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        }

       

        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));

$expenseList = "";

        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));


        if($voucherNo == "" || $voucherNo === '' || empty($voucherNo)){
            
            $expenseList   = $this->expense_model->search2('', $start_date, $end_date,"No Voucher", $expense_mode);
            
        }else{
            $expenseList   = $this->expense_model->search2('', $start_date, $end_date, $voucherNo, $expense_mode);
        }
        



        $m               = json_decode($expenseList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $grand_total += $value->amount;



                $row       = array();

                $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                $row[]     = $value->exp_category;

                $row[]     = $value->name;

                $row[]     = $value->exp_voucher_no;

                $row[]     = $value->note;
                
                $row[]     = $value->expense_mode;

                $row[]     = $currency_symbol . amountFormat($value->amount);

                $dt_data[] = $row;

            }

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";
            
            $footer_row[] = "";

            $footer_row[] = "<b>" . $this->lang->line('grand_total'). "</b>";

            $footer_row[] = "<b>" . $currency_symbol . amountFormat($grand_total). "</b>";

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }

    public function printvouher()
    {
        $data['sch_setting'] = $this->sch_setting_detail;
        $voucherNo     = $this->input->post('voucherno');

        $expenseList   = $this->expense_model->getvoucher($voucherNo);
        
        $data['expenses'] = $expenseList;
        $this->load->view('print/printExpensevoucher', $data);
    
    }
    
    
    public function getvoucherlistbydtw()
    
    {
        
        $search_type   = $this->input->post('search_type');

        $date_from     = $this->input->post('date_from');

        $date_to       = $this->input->post('date_to');

        $voucherNo     = $this->input->post('exp_voucher_no');
        
        $expense_mode  = $this->input->post('expense_mode');



        if ($search_type == "") {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        } else {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        }

       

        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));

$cancelReceipts = "";

        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));



        $cancelList   = $this->expense_model->searchCancel('', '', '', '');

        $m               = json_decode($cancelList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $grand_total += $value->voucher_amount;


                $row       = array();

                // $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                
                $row[]     = $value->exp_voucher_no;

                $row[]     = $value->exp_category;

                $row[]     = $currency_symbol . amountFormat($value->voucher_amount);
                
                $row[]     =  '<button  class="btn btn-xs btn-default printvou" voucherno="'. $value->exp_voucher_no .'"><i class="fa fa-print"></i> </button>';

                $dt_data[] = $row;

            }


            $footer_row[] = "";


            $footer_row[] = "<b>" . $this->lang->line('grand_total'). "</b>";

            $footer_row[] = "<b>" . $currency_symbol . amountFormat($grand_total). "</b>";

            
            $footer_row[] = "";

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }

    


    public function getvoucherlistbydt()
    
    {

        $voucherNo     = $this->input->post('exp_voucher_no');

        $expenseList   = $this->expense_model->search('', '', '', '');


        $m               = json_decode($expenseList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $grand_total += $value->voucher_amount;


                $row       = array();

                // $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                
                $row[]     = $value->exp_voucher_no;

                $row[]     = $value->exp_category;

                $row[]     = $currency_symbol . amountFormat($value->voucher_amount);
                
                $row[]     =  '<button  class="btn btn-xs btn-default printvou" voucherno="'. $value->exp_voucher_no .'"><i class="fa fa-print"></i> </button>';

                $dt_data[] = $row;

            }


            $footer_row[] = "";


            $footer_row[] = "<b>" . $this->lang->line('grand_total'). "</b>";

            $footer_row[] = "<b>" . $currency_symbol . amountFormat($grand_total). "</b>";

            
            $footer_row[] = "";

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }

    public function getcancelfees()
    {

       
        // $voucherNo     = $this->input->post('exp_voucher_no');
        
         $search_type   = $this->input->post('search_type');

        $date_from     = $this->input->post('date_from');

        $date_to       = $this->input->post('date_to');

        $voucherNo     = $this->input->post('exp_voucher_no');
        
        $expense_mode  = $this->input->post('expense_mode');


        if ($search_type == "") {

            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        } else {

            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        }


        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));

$cancelReceipts = "";

        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));


        $cancelList   = $this->expense_model->cancelfeesearch('', $start_date, $end_date, '');

        $m               = json_decode($cancelList);

        // $cancelfeeList   = $this->expense_model->cancelfeesearch('', '', '', '');


        // $m               = json_decode($cancelfeeList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $grand_total += $value->amount;


                $row       = array();

                // $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                $fdetails =  json_decode($value->fee_detail, true);
                
                // $row[]     = $value->receipt_no;
                $row[]     = $value->id;
                
                $row[]     = $fdetails[0]['firstname']." ".$fdetails[0]['lastname'];
                
                $row[]     = $fdetails[0]['class']." ( ".$fdetails[0]['section']. " )";

                $row[]     = $value->comment;

                $row[]     = $currency_symbol . amountFormat($value->amount);
                
                $row[]     =  date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->receipt_date));
                $dt_data[] = $row;

            }


            $footer_row[] = "";
            
            $footer_row[] = "";
            
            $footer_row[] = "";

            $footer_row[] = "<b>" . $this->lang->line('grand_total'). "</b>";

            $footer_row[] = "<b>" . $currency_symbol . amountFormat($grand_total). "</b>";

            
            $footer_row[] = "";

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }

    public function getcancelfees22()

    {

       
        $voucherNo     = $this->input->post('exp_voucher_no');

        $cancelfeeList   = $this->expense_model->cancelfeesearch('', '', '', '');


        $m               = json_decode($cancelfeeList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $grand_total += $value->amount;


                $row       = array();

                // $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                
                $row[]     = $value->receipt_no;

                $row[]     = $value->comment;

                $row[]     = $currency_symbol . amountFormat($value->amount);
                $row[]     =  date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->receipt_date));
                $dt_data[] = $row;

            }


            $footer_row[] = "";


            $footer_row[] = "<b>" . $this->lang->line('grand_total'). "</b>";

            $footer_row[] = "<b>" . $currency_symbol . amountFormat($grand_total). "</b>";

            
            $footer_row[] = "";

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }



    public function payroll()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/payroll');

        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['date_type']   = $this->customlib->date_type();

        $data['date_typeid'] = '';



        if (isset($_POST['search_type']) && $_POST['search_type'] != '') {



            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];



        } else {



            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';



        }



        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $data['label']        = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        $data['payment_mode'] = $this->payment_mode;



        $result              = $this->payroll_model->getbetweenpayrollReport($start_date, $end_date);

        $data['payrollList'] = $result;

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/payroll', $data);

        $this->load->view('layout/footer', $data);

    }

    

    public function incomegroup()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/incomegroup');

        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['date_type']   = $this->customlib->date_type();

        $data['date_typeid'] = '';

        $data['headlist']    = $this->incomehead_model->get();

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/incomegroup', $data);

        $this->load->view('layout/footer', $data);

    } 



    public function dtincomegroupreport()

    {

        $search_type = $this->input->post('search_type');

        $date_from   = $this->input->post('date_from');

        $date_to     = $this->input->post('date_to');

        $head        = $this->input->post('head');



        if (isset($search_type) && $search_type != '') {



            $dates               = $this->customlib->get_betweendate($search_type);

            $data['search_type'] = $_POST['search_type'];



        } else {



            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';



        }

        $data['head_id'] = $head_id = "";

        if (isset($_POST['head']) && $_POST['head'] != '') {

            $data['head_id'] = $head_id = $_POST['head'];

        }



        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $data['label']   = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        $incomeList      = $this->income_model->searchincomegroup($start_date, $end_date, $head_id);

        $m               = json_decode($incomeList);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;



        if (!empty($m->data)) {

            $grd_total  = 0;

            $inchead_id = 0;

            $count      = 0;

            foreach ($m->data as $key => $value) {

                $income_head[$value->head_id][] = $value;

            }



            foreach ($m->data as $key => $value) {

                $inc_head_id  = $value->head_id;

                $total_amount = "<b>" . $value->amount . "</b>";

                $grd_total += $value->amount;

                $row = array();

                if ($inchead_id == $inc_head_id) {

                    $row[] = "";

                    $count++;

                } else {

                    $row[] = $value->income_category;

                    $count = 0;

                }

                $row[]      = $value->id;

                $row[]      = $value->name;

                $row[]      = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                $row[]      = $value->invoice_no;

                $row[]      = amountFormat($value->amount);

                $dt_data[]  = $row;

                $inchead_id = $value->head_id;

                $sub_total  = 0;

                if ($count == (count($income_head[$value->head_id]) - 1)) {

                    foreach ($income_head[$value->head_id] as $inc_headkey => $inc_headvalue) {

                        $sub_total += $inc_headvalue->amount;

                    }

                    $amount_row   = array();

                    $amount_row[] = "";

                    $amount_row[] = "";

                    $amount_row[] = "";

                    $amount_row[] = "";

                    $amount_row[] = "<b>" . $this->lang->line('sub_total') . "</b>";

                    $amount_row[] = "<b>" . $currency_symbol . amountFormat($sub_total) . "</b>";

                    $dt_data[]    = $amount_row;

                }

            }



            $grand_total  = "<b>" . $currency_symbol . amountFormat($grd_total) . "</b>";

            $footer_row   = array();

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "<b>" . $this->lang->line('total') . "</b>";

            $footer_row[] = $grand_total;

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }    

    

    public function getgroupreportparam()

    {

        $search_type = $this->input->post('search_type');

        $head        = $this->input->post('head');

        $expense_mode        = $this->input->post('expense_mode');

        $date_from = "";

        $date_to   = "";

        if ($search_type == 'period') {



            $date_from = $this->input->post('date_from');

            $date_to   = $this->input->post('date_to');

        }



        $params = array('search_type' => $search_type,'expense_mode' => $expense_mode, 'head' => $head, 'date_from' => $date_from, 'date_to' => $date_to);

        $array  = array('status' => 1, 'error' => '', 'params' => $params);

        echo json_encode($array);

    }

    

    public function expensegroup()

    {

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/expensegroup');

        $data['searchlist']  = $this->customlib->get_searchtype();

        $data['date_type']   = $this->customlib->date_type();

        $data['date_typeid'] = '';

        $data['headlist']    = $this->expensehead_model->get();



        $this->load->view('layout/header', $data);

        $this->load->view('financereports/expensegroup', $data);

        $this->load->view('layout/footer', $data);

    }   



    public function dtexpensegroupreport()

    {

        $search_type = $this->input->post('search_type');

        $date_from   = $this->input->post('date_from');

        $date_to     = $this->input->post('date_to');

        $head        = $this->input->post('head');
        
        $expense_mode        = $this->input->post('expense_mode');



        $data['date_type']   = $this->customlib->date_type();

        $data['date_typeid'] = '';



        if (isset($_POST['search_type']) && $_POST['search_type'] != '') {



            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];



        } else {



            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';



        }



        $data['head_id'] = $head_id = "";

        if (isset($_POST['head']) && $_POST['head'] != '') {

            $data['head_id'] = $head_id = $_POST['head'];

        }
        
        $data['expense_mode'] = $expense_mode = "";

        if (isset($_POST['expense_mode']) && $_POST['expense_mode'] != '') {

            $data['expense_mode'] = $expense_mode = $_POST['expense_mode'];

        }



        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));



        $data['label'] = date($this->customlib->getSchoolDateFormat(), strtotime($start_date)) . " " . $this->lang->line('to') . " " . date($this->customlib->getSchoolDateFormat(), strtotime($end_date));

        // file_put_contents("groupt.txt",$start_date."-".$end_date."-". $head_id."-". $expense_mode);
        
        $result        = $this->expensehead_model->searchexpensegroup($start_date, $end_date, $head_id, $expense_mode);


        $m               = json_decode($result);

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $dt_data         = array();

        $grand_total     = 0;

        if (!empty($m->data)) {

            foreach ($m->data as $key => $value) {

                $expense_head[$value->exp_head_id][] = $value;

            }



            $grd_total  = 0;

            $exphead_id = 0;

            $count      = 0;

            foreach ($m->data as $key => $value) {



                $exp_head_id  = $value->exp_head_id;

                $total_amount = "<b>" . $value->total_amount . "</b>";

                $grd_total += $value->total_amount;

                $row = array();



                if ($exphead_id == $exp_head_id) {

                    $row[] = "";

                    $count++;

                } else {

                    $row[] = $value->exp_category;

                    $count = 0;

                }



                // $row[]      = $value->id;
                $row[]      = $value->exp_voucher_no;

                $row[]      = $value->name;

                $row[]      = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));

                $row[]      = $value->note;
                
                $row[]      = $value->expense_mode;

                $row[]      = amountFormat($value->amount);

                $dt_data[]  = $row;

                $exphead_id = $value->exp_head_id;

                $sub_total  = 0;

                if ($count == (count($expense_head[$value->exp_head_id]) - 1)) {

                    foreach ($expense_head[$value->exp_head_id] as $exp_headkey => $exp_headvalue) {

                        $sub_total += $exp_headvalue->amount;

                    }

                    $amount_row   = array();

                    $amount_row[] = "";

                    $amount_row[] = "";

                    $amount_row[] = "";
                    
                    $amount_row[] = "";

                    $amount_row[] = "";

                    $amount_row[] = "<b>" . $this->lang->line('sub_total') . "</b>";

                    $amount_row[] = "<b>" . $currency_symbol . amountFormat($sub_total) . "</b>";

                    $dt_data[]    = $amount_row;

                }



            }



            $grand_total  = "<b>" . $currency_symbol . amountFormat($grd_total) . "</b>";

            $footer_row   = array();

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";

            $footer_row[] = "";
            
            $footer_row[] = "";

            $footer_row[] = "<b>" . $this->lang->line('total') . "</b>";

            $footer_row[] = $grand_total;

            $dt_data[]    = $footer_row;

        }



        $json_data = array(

            "draw"            => intval($m->draw),

            "recordsTotal"    => intval($m->recordsTotal),

            "recordsFiltered" => intval($m->recordsFiltered),

            "data"            => $dt_data,

        );

        echo json_encode($json_data);

    }

    

    public function onlineadmission()

    {

        if (!$this->rbac->hasPrivilege('online_admission', 'can_view')) {

            access_denied();

        }

        

        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'Reports/finance');

        $this->session->set_userdata('subsub_menu', 'Reports/finance/onlineadmission');

        $data['searchlist'] = $this->customlib->get_searchtype();

        $data['group_by']   = $this->customlib->get_groupby();



        if (isset($_POST['search_type']) && $_POST['search_type'] != '') {



            $dates               = $this->customlib->get_betweendate($_POST['search_type']);

            $data['search_type'] = $_POST['search_type'];

        } else {



            $dates               = $this->customlib->get_betweendate('this_year');

            $data['search_type'] = '';

        }



        $collection = array();

        $start_date = date('Y-m-d', strtotime($dates['from_date']));

        $end_date   = date('Y-m-d', strtotime($dates['to_date']));

        $this->form_validation->set_rules('search_type', $this->lang->line('search_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {



            $data['collectlist'] = array();



        } else {



            $data['collectlist'] = $this->onlinestudent_model->getOnlineAdmissionFeeCollectionReport($start_date, $end_date);



        }

        $data['sch_setting'] = $this->sch_setting_detail;

        $this->load->view('layout/header', $data);

        $this->load->view('financereports/onlineadmission', $data);

        $this->load->view('layout/footer', $data);

    }

    

    private  function getduefeetilldate($fee_value){
        
        if (($fee_value->fine_implement_date != "0000-00-00" && $fee_value->fine_implement_date != null) && (strtotime($fee_value->fine_implement_date) < strtotime(date('Y-m-d')))) {
            // exit();
            
            $fees_fine_amount       = $fee_value->fine_amount;

            if ($fee_value->fine_type === 'daily' && ($feetype_balance > 0  || empty($fee_value->amount_detail))) {   
                
                    $startDateString = $fee_value->fine_implement_date;
                    $startDate = new DateTime($startDateString);
                    $endDate = new DateTime(); // Current date
                    
                    $interval = $endDate->diff($startDate);
                    $days_diff = $interval->days;
                    
                    $fees_fine_amount       =  ($fee_value->fine_amount * $days_diff);
                
            }
                
            if ($fee_value->fine_type === 'custom' && ($feetype_balance > 0  || empty($fee_value->amount_detail))) {            

                    $fine_temp=0;
                    $startDateString = $fee_value->fine_implement_date;
                    $startDate = new DateTime($startDateString);
                    $endDate = new DateTime(); // Current date
                    
                    $interval = $endDate->diff($startDate);
                    // $days_diff = $interval->d;
                    $days_diff = $interval->days;
                    // echo "=======".$days_diff."=========";
                    if($days_diff >= 1 && $days_diff <=5){
                        $fine_temp =10;
                    }else if($days_diff >=6  && $days_diff <=10){
                        $fine_temp=20;
                    }else if($days_diff >=11){
                        $fine_temp =30;
                    }
                   $fees_fine_amount       =  $fine_temp;
                //    $fees_fine_amount1       = $fees_fine_amount - $fee_fine;
            }
           
            $fine_bal_fee =  $fees_fine_amount - $fee_fine;

            $total_fees_fine_amount = $total_fees_fine_amount + $fees_fine_amount;
            
            $total_due_fine_bal = $total_due_fine_bal + $fees_fine_amount;
            
            // $total_due_balance   = $fee_value->amount - ($fee_paid + $fee_discount);
        }

        
        return $total_fees_fine_amount;
                       
    }



    

}

