<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>

<style type="text/css">
    @page {
        size: A4 landscape;
        margin: 0;
    }

    body, html {
        width: 297mm !important;
        height: 210mm !important;
        margin: 0 !important;
        padding: 0 !important;
        font-size: 8px !important;
    }

    .copy-title {
        text-align: center !important;
        font-weight: bold;
        text-decoration: underline;
        margin: 5px 0;
        font-size: 10px !important;
    }

    .receipt-grid {
        width: 297mm !important;
        height: 210mm !important;
        display: grid;
        grid-template-columns: 1fr 1fr;
        grid-template-rows: auto auto;
        gap: 2mm;
        padding: 5mm;
        box-sizing: border-box;
    }

    .receipt-container {
        border: 1px solid #000;
        padding: 3mm;
        box-sizing: border-box;
        page-break-inside: avoid;
        height: 90mm;
        overflow: hidden;
    }

    .top-left {
        grid-column: 1;
        grid-row: 1;
    }

    .top-right {
        grid-column: 2;
        grid-row: 1;
    }

    .bottom-center {
        grid-column: 1 / span 2;
        grid-row: 2;
        width: 141mm;
        height: 90mm;
        margin: 0 auto;
    }

    .invoice {
        padding: 0 !important;
        margin: 0 !important;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .header img {
        height: 20mm !important;
        width: 100% !important;
        object-fit: contain;
    }

    address, h5, .footer, .text, p, div, span {
        text-align: left !important;
        font-size: 9px !important;
        line-height: 1.3 !important;
        margin: 0 0 2mm 0 !important;
    }

    .text-center {
        text-align: center !important;
    }
    
    .text-right {
        text-align: right !important;
    }

    .table {
        width: 100% !important;
        font-size: 8px !important;
        margin-bottom: 2mm !important;
        table-layout: fixed;
    }

    .table th, .table td {
        padding: 2px !important;
        line-height: 1.2 !important;
        word-wrap: break-word;
    }

    .table-responsive {
        overflow-x: auto;
        overflow-y: visible;
        flex-grow: 1;
    }

    /* Column width classes */
    .date-col { width: 15%; }
    .fees-group-col { width: 20%; }
    .fees-code-col { width: 15%; }
    .mode-col { width: 10%; }
    .amount-col { width: 10%; }
    .discount-col { width: 10%; }
    .fine-col { width: 10%; }
    .fine-discount-col { width: 10%; }
    .balance-col { width: 10%; }

    @media print {
        @page {
            size: A4 landscape;
            margin: 0 !important;
        }
        
        body, html {
            width: 297mm !important;
            height: 210mm !important;
        }
        
        .receipt-container {
            border: 1px solid #000 !important;
        }
    }
</style>

<html lang="en">
    <head>         
        <title><?php echo $this->lang->line('fees_receipt'); ?></title>    
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css"> 
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    </head>

    <body>       
        <?php 
        $print_copy = explode(',', $settinglist[0]['is_duplicate_fees_invoice']);
        $has_office_copy = in_array('0', $print_copy);
        $has_student_copy = in_array('1', $print_copy);
        $has_bank_copy = in_array('2', $print_copy);
        ?>

        <div class="receipt-grid">
            <?php if($has_office_copy): ?>
            <div class="receipt-container top-left">
                <!-- Office Copy Content -->
                <div class="invoice">
                    <div class="row header">
                        <div class="col-sm-12">
                            <img src="<?php echo $this->media_storage->getImageURL('/uploads/print_headerfooter/student_receipt/'.$this->setting_model->get_receiptheader()); ?>">
                        </div>
                    </div> 
                    
                    <div class="row">
                        <div class="col-md-12 text text-center copy-title">
                            <?php echo $this->lang->line('office_copy'); ?>
                        </div>
                    </div>
                    
                    <div class="row">                           
                        <div class="col-xs-6">
                            <address>
                                <strong><?php echo $this->customlib->getFullName($feeList->firstname, $feeList->middlename, $feeList->lastname, $sch_setting->middlename, $sch_setting->lastname); ?></strong><?php echo " (".$feeList->admission_no.")"; ?><br>
                                <?php echo $this->lang->line('father_name'); ?>: <?php echo $student['father_name']; ?><br>
                                <?php echo $this->lang->line('class'); ?>: <?php echo $feeList->class . " (" . $feeList->section . ")"; ?>
                            </address>
                        </div>
                        <div class="col-xs-6 text-right">
                            <address>
                                <strong><?php echo $this->lang->line('date'); ?>: <?php
                                    $date = date('d-m-Y');
                                    echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($date));
                                ?></strong><br/>
                                <strong><?php echo $this->lang->line('academic_year'). ":  " .$sch_setting->session; ?></strong><br/>
                                <strong><?php echo $this->lang->line('receipt_id'); ?>: 
                                    <?php 
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->receipt_id;
                                        }
                                    }
                                    ?>
                                </strong><br/>
                                <strong><?php echo $this->lang->line('collected_by'); ?>: 
                                    <?php  
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->collected_by;
                                        }
                                    }
                                    ?>                     
                                </strong>
                            </address>
                        </div>
                    </div>
                    
                    <hr style="margin: 2mm 0;">
                    
                    <div class="table-responsive">
                        <?php if (!empty($feeList)) { ?>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="date-col"><?php echo $this->lang->line('date'); ?></th>
                                    <th class="fees-group-col"><?php echo $this->lang->line('fees_group'); ?></th>
                                    <th class="fees-code-col"><?php echo $this->lang->line('fees_code'); ?></th>
                                    <th class="mode-col"><?php echo $this->lang->line('mode'); ?></th>
                                    <th class="amount-col text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    <th class="discount-col text-right"><?php echo $this->lang->line('discount'); ?></th>
                                    <th class="fine-col text-right"><?php echo $this->lang->line('fine'); ?></th>
                                    <th class="fine-discount-col text-right"><?php echo $this->lang->line('fine_discount'); ?></th>
                                    <th class="balance-col text-right"><?php echo $this->lang->line('balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $prev_bal1 = $feeList->amount;
                                if (isJSON($feeList->amount_detail)) {
                                    $fee = json_decode($feeList->amount_detail);
                                    $record = $fee->{$sub_invoice_id};
                                    ?>
                                    <tr>
                                        <td class="date-col">
                                            <?php echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($record->date)); ?>
                                        </td>
                                        <td class="fees-group-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->name) . " (" . $this->lang->line($feeList->type) . ")";
                                            } else {
                                                echo $feeList->name . " (" . $feeList->type . ")";
                                            }
                                            ?>
                                        </td>
                                        <td class="fees-code-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->code);
                                            } else {
                                                echo $feeList->code;
                                            }
                                            ?>
                                        </td>
                                        <td class="mode-col">
                                            <?php echo $this->lang->line(strtolower($record->payment_mode)); ?>
                                        </td>
                                        <td class="amount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount); ?>
                                        </td>
                                        <td class="discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_discount); ?>
                                        </td>
                                        <td class="fine-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_fine); ?>
                                        </td>
                                        <td class="fine-discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat(isset($record->fine_discount) ? $record->fine_discount : 0); ?>
                                        </td>
                                        <td class="balance-col text-right">
                                            <?php
                                            $prev_bal1 -= ($record->amount + $record->amount_discount);
                                            echo $currency_symbol . amountFormat($prev_bal1);
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                        <?php } ?>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->lang->line('note');?>: <?php echo $record->description; ?>
                        </div>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->setting_model->get_receiptfooter();?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if($has_student_copy): ?>
            <div class="receipt-container top-right">
                <!-- Student Copy Content -->
                <div class="invoice">
                    <div class="row header">
                        <div class="col-sm-12">
                            <img src="<?php echo $this->media_storage->getImageURL('/uploads/print_headerfooter/student_receipt/'.$this->setting_model->get_receiptheader()); ?>">
                        </div>
                    </div> 
                    
                    <div class="row">
                        <div class="col-md-12 text text-center copy-title">
                            <?php echo $this->lang->line('office_copy'); ?>
                        </div>
                    </div>
                    
                    <div class="row">                           
                        <div class="col-xs-6">
                            <address>
                                <strong><?php echo $this->customlib->getFullName($feeList->firstname, $feeList->middlename, $feeList->lastname, $sch_setting->middlename, $sch_setting->lastname); ?></strong><?php echo " (".$feeList->admission_no.")"; ?><br>
                                <?php echo $this->lang->line('father_name'); ?>: <?php echo $student['father_name']; ?><br>
                                <?php echo $this->lang->line('class'); ?>: <?php echo $feeList->class . " (" . $feeList->section . ")"; ?>
                            </address>
                        </div>
                        <div class="col-xs-6 text-right">
                            <address>
                                <strong><?php echo $this->lang->line('date'); ?>: <?php
                                    $date = date('d-m-Y');
                                    echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($date));
                                ?></strong><br/>
                                <strong><?php echo $this->lang->line('academic_year'). ":  " .$sch_setting->session; ?></strong><br/>
                                <strong><?php echo $this->lang->line('receipt_id'); ?>: 
                                    <?php 
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->receipt_id;
                                        }
                                    }
                                    ?>
                                </strong><br/>
                                <strong><?php echo $this->lang->line('collected_by'); ?>: 
                                    <?php  
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->collected_by;
                                        }
                                    }
                                    ?>                     
                                </strong>
                            </address>
                        </div>
                    </div>
                    
                    <hr style="margin: 2mm 0;">
                    
                    <div class="table-responsive">
                        <?php if (!empty($feeList)) { ?>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="date-col"><?php echo $this->lang->line('date'); ?></th>
                                    <th class="fees-group-col"><?php echo $this->lang->line('fees_group'); ?></th>
                                    <th class="fees-code-col"><?php echo $this->lang->line('fees_code'); ?></th>
                                    <th class="mode-col"><?php echo $this->lang->line('mode'); ?></th>
                                    <th class="amount-col text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    <th class="discount-col text-right"><?php echo $this->lang->line('discount'); ?></th>
                                    <th class="fine-col text-right"><?php echo $this->lang->line('fine'); ?></th>
                                    <th class="fine-discount-col text-right"><?php echo $this->lang->line('fine_discount'); ?></th>
                                    <th class="balance-col text-right"><?php echo $this->lang->line('balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $prev_bal1 = $feeList->amount;
                                if (isJSON($feeList->amount_detail)) {
                                    $fee = json_decode($feeList->amount_detail);
                                    $record = $fee->{$sub_invoice_id};
                                    ?>
                                    <tr>
                                        <td class="date-col">
                                            <?php echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($record->date)); ?>
                                        </td>
                                        <td class="fees-group-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->name) . " (" . $this->lang->line($feeList->type) . ")";
                                            } else {
                                                echo $feeList->name . " (" . $feeList->type . ")";
                                            }
                                            ?>
                                        </td>
                                        <td class="fees-code-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->code);
                                            } else {
                                                echo $feeList->code;
                                            }
                                            ?>
                                        </td>
                                        <td class="mode-col">
                                            <?php echo $this->lang->line(strtolower($record->payment_mode)); ?>
                                        </td>
                                        <td class="amount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount); ?>
                                        </td>
                                        <td class="discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_discount); ?>
                                        </td>
                                        <td class="fine-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_fine); ?>
                                        </td>
                                        <td class="fine-discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat(isset($record->fine_discount) ? $record->fine_discount : 0); ?>
                                        </td>
                                        <td class="balance-col text-right">
                                            <?php
                                            $prev_bal1 -= ($record->amount + $record->amount_discount);
                                            echo $currency_symbol . amountFormat($prev_bal1);
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                        <?php } ?>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->lang->line('note');?>: <?php echo $record->description; ?>
                        </div>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->setting_model->get_receiptfooter();?>
                        </div>
                    </div>
                    <!-- Same content as office copy but with "student_copy" title -->
                    <!-- ... -->
                </div>
            </div>
            <?php endif; ?>

            <?php if($has_bank_copy): ?>
            <div class="receipt-container bottom-center">
                <!-- Bank Copy Content -->
                <div class="invoice">
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <img src="<?php echo $this->media_storage->getImageURL('/uploads/print_headerfooter/student_receipt/'.$this->setting_model->get_receiptheader()); ?>">
                        </div>
                    </div> 
                    
                    <div class="row">
                        <div class="col-md-12 text text-center copy-title">
                            <?php echo $this->lang->line('office_copy'); ?>
                        </div>
                    </div>
                    
                    <div class="row">                           
                        <div class="col-xs-6">
                            <address>
                                <strong><?php echo $this->customlib->getFullName($feeList->firstname, $feeList->middlename, $feeList->lastname, $sch_setting->middlename, $sch_setting->lastname); ?></strong><?php echo " (".$feeList->admission_no.")"; ?><br>
                                <?php echo $this->lang->line('father_name'); ?>: <?php echo $student['father_name']; ?><br>
                                <?php echo $this->lang->line('class'); ?>: <?php echo $feeList->class . " (" . $feeList->section . ")"; ?>
                            </address>
                        </div>
                        <div class="col-xs-6 text-right">
                            <address>
                                <strong><?php echo $this->lang->line('date'); ?>: <?php
                                    $date = date('d-m-Y');
                                    echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($date));
                                ?></strong><br/>
                                <strong><?php echo $this->lang->line('academic_year'). ":  " .$sch_setting->session; ?></strong><br/>
                                <strong><?php echo $this->lang->line('receipt_id'); ?>: 
                                    <?php 
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->receipt_id;
                                        }
                                    }
                                    ?>
                                </strong><br/>
                                <strong><?php echo $this->lang->line('collected_by'); ?>: 
                                    <?php  
                                    if (isJSON($feeList->amount_detail)) {
                                        $fee = json_decode($feeList->amount_detail);
                                        $record = $fee->{$sub_invoice_id};
                                        if (!empty($record->received_by)) {
                                            echo $record->collected_by;
                                        }
                                    }
                                    ?>                     
                                </strong>
                            </address>
                        </div>
                    </div>
                    
                    <hr style="margin: 2mm 0;">
                    
                    <div class="table-responsive">
                        <?php if (!empty($feeList)) { ?>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="date-col"><?php echo $this->lang->line('date'); ?></th>
                                    <th class="fees-group-col"><?php echo $this->lang->line('fees_group'); ?></th>
                                    <th class="fees-code-col"><?php echo $this->lang->line('fees_code'); ?></th>
                                    <th class="mode-col"><?php echo $this->lang->line('mode'); ?></th>
                                    <th class="amount-col text-right"><?php echo $this->lang->line('amount'); ?></th>
                                    <th class="discount-col text-right"><?php echo $this->lang->line('discount'); ?></th>
                                    <th class="fine-col text-right"><?php echo $this->lang->line('fine'); ?></th>
                                    <th class="fine-discount-col text-right"><?php echo $this->lang->line('fine_discount'); ?></th>
                                    <th class="balance-col text-right"><?php echo $this->lang->line('balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $prev_bal1 = $feeList->amount;
                                if (isJSON($feeList->amount_detail)) {
                                    $fee = json_decode($feeList->amount_detail);
                                    $record = $fee->{$sub_invoice_id};
                                    ?>
                                    <tr>
                                        <td class="date-col">
                                            <?php echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($record->date)); ?>
                                        </td>
                                        <td class="fees-group-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->name) . " (" . $this->lang->line($feeList->type) . ")";
                                            } else {
                                                echo $feeList->name . " (" . $feeList->type . ")";
                                            }
                                            ?>
                                        </td>
                                        <td class="fees-code-col">
                                            <?php
                                            if ($feeList->is_system) {
                                                echo $this->lang->line($feeList->code);
                                            } else {
                                                echo $feeList->code;
                                            }
                                            ?>
                                        </td>
                                        <td class="mode-col">
                                            <?php echo $this->lang->line(strtolower($record->payment_mode)); ?>
                                        </td>
                                        <td class="amount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount); ?>
                                        </td>
                                        <td class="discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_discount); ?>
                                        </td>
                                        <td class="fine-col text-right">
                                            <?php echo $currency_symbol . amountFormat($record->amount_fine); ?>
                                        </td>
                                        <td class="fine-discount-col text-right">
                                            <?php echo $currency_symbol . amountFormat(isset($record->fine_discount) ? $record->fine_discount : 0); ?>
                                        </td>
                                        <td class="balance-col text-right">
                                            <?php
                                            $prev_bal1 -= ($record->amount + $record->amount_discount);
                                            echo $currency_symbol . amountFormat($prev_bal1);
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                        <?php } ?>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->lang->line('note');?>: <?php echo $record->description; ?>
                        </div>
                    </div>
                    
                    <div class="row header">
                        <div class="col-sm-12">
                            <?php echo $this->setting_model->get_receiptfooter();?>
                        </div>
                    </div>
                    
                    <!-- Same content as office copy but with "bank_copy" title -->
                    <!-- ... -->
                </div>
            </div>
            <?php endif; ?>
        </div>
    </body>
</html>