<?php
// callback.php
// Cashfree webhook handler — verifies signature and INSERTs into student_fees_deposite
// Only inserts EXACT amount_detail fetched from student_fees_master where id = feesId.
// No fallback creation. Idempotent: skips insert if same (master_id, feetype_id, amount_detail) exists.

// DB config
$servername = 'localhost';
$username   = 'zsms2_z';
$password   = 'L8=,(pg&1Cg0';
$dbname     = 'zsms2_z';

// SECRET_KEY used when creating orders (must match)
$SECRET_KEY = "cfsk_ma_test_4e5733bea36fb1094d2de073ae781608_81830881";

// logging
$logFile = __DIR__ . "/log.txt";
$now = date('Y-m-d H:i:s');

// read raw body
$rawBody = file_get_contents('php://input');

// robust header read
function get_request_header($name) {
    $key = 'HTTP_' . str_replace('-', '_', strtoupper($name));
    if (isset($_SERVER[$key])) return $_SERVER[$key];
    if (function_exists('getallheaders')) {
        $headers = getallheaders();
        foreach ($headers as $k => $v) {
            if (strtolower($k) === strtolower($name)) return $v;
        }
    }
    return null;
}

// get signature & timestamp
$header_signature = get_request_header('x-webhook-signature') ?? get_request_header('x_cashfree_signature') ?? '';
$header_timestamp = get_request_header('x-webhook-timestamp') ?? get_request_header('x_cashfree_timestamp') ?? '';

file_put_contents($logFile, "=== CALLBACK {$now} ===\nSIG: {$header_signature}\nTS: {$header_timestamp}\nGET: " . print_r($_GET, true) . "\nRAW: {$rawBody}\n\n", FILE_APPEND);

// basic header check
if (empty($header_signature) || empty($header_timestamp)) {
    file_put_contents($logFile, "Missing signature/timestamp. Aborting.\n\n", FILE_APPEND);
    http_response_code(400);
    echo "missing headers";
    exit;
}

// verify signature
$computed = base64_encode(hash_hmac('sha256', $header_timestamp . $rawBody, $SECRET_KEY, true));
if (!hash_equals($computed, $header_signature)) {
    file_put_contents($logFile, "Signature mismatch. computed={$computed} header={$header_signature}\n\n", FILE_APPEND);
    http_response_code(403);
    echo "invalid signature";
    exit;
}

// parse JSON
$payload = json_decode($rawBody, true);
if (!is_array($payload)) {
    file_put_contents($logFile, "Invalid JSON payload after signature verification.\n\n", FILE_APPEND);
    http_response_code(400);
    echo "invalid payload";
    exit;
}

// determine success (multiple possible payload shapes)
$success = false;
$txStatus = null;
$cf_order_id = null;
$payment_cf_id = null;

if (isset($payload['event']) && is_string($payload['event']) && stripos($payload['event'], 'SUCCESS') !== false) $success = true;
if (isset($payload['txStatus'])) {
    $txStatus = $payload['txStatus'];
    if (strtolower($txStatus) === 'success') $success = true;
}
if (isset($payload['data']) && is_array($payload['data'])) {
    if (isset($payload['data']['txStatus']) && strtolower($payload['data']['txStatus']) === 'success') $success = true;
    if (isset($payload['data']['order']['order_id'])) $cf_order_id = $payload['data']['order']['order_id'];
    if (isset($payload['data']['payment']['cf_payment_id'])) $payment_cf_id = $payload['data']['payment']['cf_payment_id'];
    if (isset($payload['data']['payment']['payment_id'])) $payment_cf_id = $payment_cf_id ?? $payload['data']['payment']['payment_id'];
}
if (isset($payload['orderId'])) $cf_order_id = $payload['orderId'];
if (isset($payload['cf_order_id'])) $cf_order_id = $payload['cf_order_id'];
if (isset($payload['payment_id'])) $payment_cf_id = $payload['payment_id'];
if (isset($payload['tx_id'])) $payment_cf_id = $payment_cf_id ?? $payload['tx_id'];

// last-resort search for "SUCCESS"
if (!$success) {
    $flat = json_encode($payload);
    if (stripos($flat, 'SUCCESS') !== false) $success = true;
}

file_put_contents($logFile, "Webhook eval: success=" . ($success ? '1' : '0') . " txStatus=" . var_export($txStatus, true) . " cf_order_id=" . var_export($cf_order_id, true) . " payment_cf_id=" . var_export($payment_cf_id, true) . "\n", FILE_APPEND);

if (!$success) {
    file_put_contents($logFile, "Payment not successful — aborting.\n\n", FILE_APPEND);
    http_response_code(200);
    echo "ignored";
    exit;
}

// REQUIRE feesId (student_fees_master_id)
$fees_master_id = 0;
$fees_feetype_id = 0;

if (isset($_GET['feesId'])) $fees_master_id = intval($_GET['feesId']);
if (isset($_GET['feesTypeId'])) $fees_feetype_id = intval($_GET['feesTypeId']);

// fallback to payload->data only if GET missing
if ($fees_master_id === 0 && isset($payload['data']['feesId'])) $fees_master_id = intval($payload['data']['feesId']);
if ($fees_feetype_id === 0 && isset($payload['data']['feesTypeId'])) $fees_feetype_id = intval($payload['data']['feesTypeId']);

if ($fees_master_id <= 0) {
    file_put_contents($logFile, "Missing feesId (student_fees_master_id). Aborting as requested.\nPayload: " . json_encode($payload) . "\n\n", FILE_APPEND);
    http_response_code(400);
    echo "missing feesId";
    exit;
}

// Fetch exact amount_detail from student_fees_master
$lookupDb = new mysqli($servername, $username, $password, $dbname);
if ($lookupDb->connect_errno) {
    file_put_contents($logFile, "DB connect error (lookup): " . $lookupDb->connect_error . "\n", FILE_APPEND);
    http_response_code(500);
    echo "db error";
    exit;
}
$lookupDb->set_charset('utf8mb4');

$stmt = $lookupDb->prepare("SELECT amount_detail FROM student_fees_deposite WHERE student_fees_master_id = ? LIMIT 1");
if (!$stmt) {
    file_put_contents($logFile, "Lookup prepare failed: " . $lookupDb->error . "\n", FILE_APPEND);
    $lookupDb->close();
    http_response_code(500);
    echo "prepare error";
    exit;
}
$stmt->bind_param('i', $fees_master_id);
if (!$stmt->execute()) {
    file_put_contents($logFile, "Lookup execute failed: " . $stmt->error . "\n", FILE_APPEND);
    $stmt->close();
    $lookupDb->close();
    http_response_code(500);
    echo "execute error";
    exit;
}
$res = $stmt->get_result();
$row = $res ? $res->fetch_assoc() : null;
$stmt->close();
$lookupDb->close();

if (!$row) {
    file_put_contents($logFile, "No student_fees_master row for id={$fees_master_id}. Aborting.\n", FILE_APPEND);
    http_response_code(400);
    echo "no master row";
    exit;
}
if (!isset($row['amount_detail']) || trim((string)$row['amount_detail']) === '') {
    file_put_contents($logFile, "amount_detail missing or empty in student_fees_master id={$fees_master_id}. Aborting (no fallback allowed).\n", FILE_APPEND);
    http_response_code(400);
    echo "no amount_detail";
    exit;
}

// exact amount_detail
// exact amount_detail from master
$amount_detail_json = $row['amount_detail'];

// Decode JSON to array
$amount_array = json_decode($amount_detail_json, true);

if (is_array($amount_array)) {
    $today = date("Y-m-d");

    // update date field for each sub-entry
    foreach ($amount_array as $key => &$detail) {
        if (isset($detail['date'])) {
            $detail['date'] = $today;
        }
    }

    // Encode back to JSON (with unescaped slashes for neatness)
    $amount_detail_json = json_encode($amount_array, JSON_UNESCAPED_SLASHES);
}



//Updtae here With New Date






// Connect for insertion & duplicate check
$mysqli = new mysqli($servername, $username, $password, $dbname);
if ($mysqli->connect_errno) {
    file_put_contents($logFile, "DB connect error (insert): " . $mysqli->connect_error . "\n", FILE_APPEND);
    http_response_code(500);
    echo "db error";
    exit;
}
$mysqli->set_charset('utf8mb4');

// ensure feetype id set (0 if not provided)
if ($fees_feetype_id === 0) {
    if (isset($payload['data']['feesTypeId'])) $fees_feetype_id = intval($payload['data']['feesTypeId']);
    elseif (isset($_GET['feesTypeId'])) $fees_feetype_id = intval($_GET['feesTypeId']);
    else $fees_feetype_id = 0;
}

// duplicate prevention: exact match on master_id+feetype+amount_detail
$exists = false;
$checkSql = "SELECT id FROM student_fees_deposite WHERE student_fees_master_id = ? AND fee_groups_feetype_id = ? AND amount_detail = ? LIMIT 1";
$stmtCheck = $mysqli->prepare($checkSql);
if ($stmtCheck) {
    $stmtCheck->bind_param('iis', $fees_master_id, $fees_feetype_id, $amount_detail_json);
    if ($stmtCheck->execute()) {
        $resCheck = $stmtCheck->get_result();
        if ($resCheck && $resCheck->fetch_assoc()) $exists = true;
    } else {
        file_put_contents($logFile, "Duplicate-check execute error: " . $stmtCheck->error . "\n", FILE_APPEND);
    }
    $stmtCheck->close();
} else {
    file_put_contents($logFile, "Prepare failed for duplicate-check: " . $mysqli->error . "\n", FILE_APPEND);
    // continue but risk duplicate if multiple retries; recommended to add DB unique key later
}

// optional extra duplicate guard using cf_payment_id or payment_cf_id if available
$payment_cf_id = null;
if (isset($payload['data']['payment']['cf_payment_id'])) $payment_cf_id = $payload['data']['payment']['cf_payment_id'];
elseif (isset($payload['data']['payment']['payment_id'])) $payment_cf_id = $payload['data']['payment']['payment_id'];
if (!$exists && $payment_cf_id) {
    $likeTerm = '%' . $mysqli->real_escape_string($payment_cf_id) . '%';
    $stmtCf = $mysqli->prepare("SELECT id FROM student_fees_deposite WHERE amount_detail LIKE ? LIMIT 1");
    if ($stmtCf) {
        $stmtCf->bind_param('s', $likeTerm);
        if ($stmtCf->execute()) {
            $r = $stmtCf->get_result();
            if ($r && $r->fetch_assoc()) $exists = true;
        } else {
            file_put_contents($logFile, "cf_payment_id duplicate-check execute error: " . $stmtCf->error . "\n", FILE_APPEND);
        }
        $stmtCf->close();
    }
}

if ($exists) {
    file_put_contents($logFile, "Duplicate detected — deposit already exists for master_id={$fees_master_id}, feetype={$fees_feetype_id}. Skipping insert.\n", FILE_APPEND);
    http_response_code(200);
    echo "already exists";
    $mysqli->close();
    exit;
}

// perform insert: student_fees_master_id, fee_groups_feetype_id, student_transport_fee_id NULL, amount_detail exact
$insertSql = "INSERT INTO student_fees_deposite (student_fees_master_id, fee_groups_feetype_id, student_transport_fee_id, amount_detail) VALUES (?, ?, NULL, ?)";
$stmtInsert = $mysqli->prepare($insertSql);
if (!$stmtInsert) {
    file_put_contents($logFile, "Prepare failed for INSERT: " . $mysqli->error . "\n", FILE_APPEND);
    http_response_code(500);
    echo "prepare error";
    $mysqli->close();
    exit;
}
$stmtInsert->bind_param('iis', $fees_master_id, $fees_feetype_id, $amount_detail_json);
$ok = $stmtInsert->execute();
if ($ok) {
    $new_id = $mysqli->insert_id;
    file_put_contents($logFile, "Inserted student_fees_deposite id={$new_id} for master_id={$fees_master_id} feetype={$fees_feetype_id} (cf_order_id={$cf_order_id}, payment_cf_id={$payment_cf_id})\n", FILE_APPEND);
    http_response_code(200);
    echo "inserted";
    $stmtInsert->close();
    $mysqli->close();
    exit;
} else {
    file_put_contents($logFile, "INSERT ERROR: " . $stmtInsert->error . " SQL: {$insertSql}\n", FILE_APPEND);
    http_response_code(500);
    echo "insert error";
    $stmtInsert->close();
    $mysqli->close();
    exit;
}
