<?php
// corephp/cashfee/create_order.php
// Final version: static amount, calls Cashfree /orders and returns success:true + paymentSessionId

header('Content-Type: application/json; charset=utf-8');

// ---------- CONFIG ----------
$CF_CLIENT_ID = '10423844c405d78f2be3a65f1a84832401';         // sandbox id
$CF_CLIENT_SECRET = 'cfsk_ma_prod_e22f3ec5dfe408ccf58be5d0a492fc96_edaa580c'; // sandbox secret
$ENVIRONMENT = 'PRODUCTION'; // SANDBOX while testing
$API_VERSION = '2023-08-01';

// optional logfile for debugging (will append)
function logfile($msg) {
    $file = __DIR__ . '/create_order.log';
    $line = '[' . date('Y-m-d H:i:s') . '] ' . $msg . PHP_EOL;
    file_put_contents($file, $line, FILE_APPEND | LOCK_EX);
}

// Read request
$raw = file_get_contents('php://input');
logfile("RAW REQUEST: " . $raw);
$input = json_decode($raw, true);
if (!$input) {
    http_response_code(400);
    echo json_encode(['success'=>false,'error'=>'Invalid JSON input','received'=>$raw]);
    exit;
}

// STATIC amount
$amount = "100.00"; // INR

// Build order payload
$currency = $input['currency'] ?? 'INR';
$studentId = $input['studentId'] ?? 'UNKNOWN';
$customer_name  = $input['customer_name'] ?? 'Student';
$customer_email = $input['customer_email'] ?? 'student@example.com';
$customer_phone = $input['customer_phone'] ?? '9999999999';
$order_note     = $input['order_note'] ?? 'Fees payment';

$orderId = 'ORDER_' . time() . '_' . rand(1000,9999);

$orderPayload = [
    "order_id" => $orderId,
    "order_amount" => (string)$amount,
    "order_currency" => $currency,
    "order_note" => $order_note,
    "customer_details" => [
        "customer_id" => $studentId,
        "customer_name" => $customer_name,
        "customer_email" => $customer_email,
        "customer_phone" => $customer_phone
    ]
];

logfile("Order payload: " . json_encode($orderPayload));

// Call Cashfree
$endpoint = ($ENVIRONMENT === 'PRODUCTION') ? 'https://api.cashfree.com/pg/orders' : 'https://sandbox.cashfree.com/pg/orders';
$headers = [
    'Content-Type: application/json',
    'x-client-id: ' . $CF_CLIENT_ID,
    'x-client-secret: ' . $CF_CLIENT_SECRET,
    'x-api-version: ' . $API_VERSION
];

$ch = curl_init($endpoint);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderPayload));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);

$resp = curl_exec($ch);
$curlErr = curl_error($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

logfile("Cashfree HTTP code={$httpcode} resp=" . $resp);
if ($resp === false) {
    http_response_code(502);
    echo json_encode(['success'=>false,'error'=>'cURL error','message'=>$curlErr]);
    exit;
}

$responseJson = json_decode($resp, true);
if (!is_array($responseJson)) {
    // Return raw body to help debug (but Android expects JSON)
    http_response_code(502);
    echo json_encode(['success'=>false,'error'=>'Non-JSON response from Cashfree','body'=>$resp]);
    exit;
}

// Extract payment_session_id from common places
$paymentSessionId = null;
if (!empty($responseJson['payment_session_id'])) {
    $paymentSessionId = $responseJson['payment_session_id'];
} elseif (!empty($responseJson['payment_session'])) {
    $paymentSessionId = $responseJson['payment_session'];
} elseif (!empty($responseJson['paymentSessionId'])) {
    $paymentSessionId = $responseJson['paymentSessionId'];
} elseif (!empty($responseJson['data']['payment_session_id'])) {
    $paymentSessionId = $responseJson['data']['payment_session_id'];
} elseif (!empty($responseJson['payment_session_id'])) {
    $paymentSessionId = $responseJson['payment_session_id'];
} elseif (!empty($responseJson['payment_session'])) {
    $paymentSessionId = $responseJson['payment_session'];
}

// If we still don't have session id, but Cashfree returned an active order with 'payment_session_id' key embedded differently
if (empty($paymentSessionId)) {
    // scan JSON for any key containing 'payment_session'
    $flat = json_encode($responseJson);
    if (preg_match('/"payment[_\- ]?session[_\- ]?id"\s*:\s*"([^"]+)"/i', $flat, $m)) {
        $paymentSessionId = $m[1];
    } elseif (preg_match('/"payment[_\- ]?session"\s*:\s*"([^"]+)"/i', $flat, $m)) {
        $paymentSessionId = $m[1];
    }
}

if (empty($paymentSessionId)) {
    // return Cashfree body so Android can show exact error
    http_response_code(400);
    logfile("No paymentSessionId found in Cashfree response: " . json_encode($responseJson));
    echo json_encode(['success'=>false,'error'=>'Missing paymentSessionId','cashfree'=>$responseJson]);
    exit;
}

// Success — respond in the shape Android expects
$out = [
    'success' => true,
    'orderId' => $orderId,
    'paymentSessionId' => $paymentSessionId,
    'amount' => $amount,
    'environment' => $ENVIRONMENT
];

logfile("Returning success: " . json_encode($out));
http_response_code(200);
echo json_encode($out);
exit;
