<?php
// success.php
// Minimal user-facing success page: animated green tick + "Fees Paid Successfully".
// When loaded inside your Android WebView, it will call Android.onPaymentSuccess({...}).

$logFile = __DIR__ . "/log.txt";

// collect query params (we will log but not show)
$order_id   = isset($_GET['order_id']) ? $_GET['order_id'] : null;
$feesId     = isset($_GET['feesId']) ? $_GET['feesId'] : null;
$feesTypeId = isset($_GET['feesTypeId']) ? $_GET['feesTypeId'] : null;
$amountdetails_b64 = isset($_GET['amountdetails_b64']) ? $_GET['amountdetails_b64'] : null;

$amountdetails = null;
if ($amountdetails_b64) {
    $decoded = base64_decode($amountdetails_b64, true);
    if ($decoded !== false) {
        $amountdetails = json_decode($decoded, true);
    }
}

// Log the return call for your records (won't be shown to user)
$logData = "=== SUCCESS PAGE " . date("Y-m-d H:i:s") . " ===\n";
$logData .= "Query: " . print_r($_GET, true) . "\n";
file_put_contents($logFile, $logData, FILE_APPEND);

// Build a small JSON payload for Android bridge
$jsPayload = [
    'order_id' => $order_id,
    'status' => 'SUCCESS',
    'feesId' => $feesId,
    'feesTypeId' => $feesTypeId
];
$jsPayloadJson = json_encode($jsPayload);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Payment Successful</title>
  <style>
    :root{
      --green: #00C853; /* bright green */
      --bg: #f6fbf8;
      --card: #ffffff;
      --muted: #6c757d;
    }
    html,body{height:100%;}
    body{
      margin:0;
      font-family: Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      background: linear-gradient(180deg, var(--bg), #f0f9f3);
      display:flex;
      align-items:center;
      justify-content:center;
      padding:24px;
    }
    .card{
      background: var(--card);
      border-radius:14px;
      padding:36px 28px;
      box-shadow: 0 10px 30px rgba(16, 124, 62, 0.08);
      max-width:520px;
      width:100%;
      text-align:center;
    }
    .tick {
      width:120px;
      height:120px;
      margin: 0 auto 18px;
    }
    .circle {
      stroke: var(--green);
      stroke-width:8;
      fill: none;
      stroke-linecap: round;
      stroke-linejoin: round;
      stroke-dasharray: 340;
      stroke-dashoffset: 340;
      animation: drawCircle 700ms ease-out forwards;
    }
    @keyframes drawCircle {
      to { stroke-dashoffset: 0; }
    }
    .check {
      stroke: #fff;
      stroke-width: 7;
      fill: none;
      stroke-linecap: round;
      stroke-linejoin: round;
      stroke-dasharray: 48;
      stroke-dashoffset: 48;
      animation: drawCheck 450ms ease-out 650ms forwards;
    }
    @keyframes drawCheck {
      to { stroke-dashoffset: 0; }
    }
    .circle-fill {
      fill: var(--green);
      opacity: 0;
      transform-origin: 50% 50%;
      animation: fillPulse 300ms ease-out 900ms forwards;
    }
    @keyframes fillPulse {
      to { opacity: 1; transform: scale(1); }
    }
    h1 { margin: 6px 0 0; font-size:22px; color: #0f5132; font-weight:600; }
    p.sub { margin:8px 0 20px; color:var(--muted); font-size:14px; }
    .actions { display:flex; gap:10px; justify-content:center; margin-top:12px; }
    .btn { border:0; padding:10px 18px; border-radius:8px; cursor:pointer; font-weight:600; font-size:14px; }
    .btn-primary { background: var(--green); color:#fff; box-shadow: 0 6px 18px rgba(0, 200, 83, 0.18); }
    .btn-ghost { background: transparent; color: #0f5132; border: 1px solid rgba(15,81,50,0.08); }
    @media (max-width:420px){
      .card { padding:24px; }
      .tick { width:96px; height:96px; }
      h1 { font-size:18px; }
    }
  </style>
</head>
<body>
  <div class="card" role="status" aria-live="polite">
    <!-- Animated tick -->
    <svg class="tick" viewBox="0 0 120 120" aria-hidden="true">
      <circle class="circle" cx="60" cy="60" r="52"></circle>
      <circle class="circle-fill" cx="60" cy="60" r="52"></circle>
      <path class="check" d="M36 62 L52 78 L86 42"></path>
    </svg>

    <h1>Fees Paid Successfully</h1>
    <p class="sub">Thank you — your payment was received.</p>

    
  </div>

  <script>
    // payload prepared by server
    var payload = <?php echo $jsPayloadJson; ?>;

    // notify Android native app via JS bridge if available
    function notifyAndroidOnce() {
      try {
        if (window.Android && typeof window.Android.onPaymentSuccess === 'function') {
          // send JSON string to native side
          window.Android.onPaymentSuccess(JSON.stringify(payload));
          return true;
        }
      } catch (e) {
        // swallow, will retry
      }
      return false;
    }

    // try immediate and then retry for up to ~2 seconds (20 attempts at 100ms)
    (function tryNotify() {
      if (notifyAndroidOnce()) return;
      var attempts = 0;
      var iv = setInterval(function() {
        attempts++;
        if (notifyAndroidOnce() || attempts >= 20) {
          clearInterval(iv);
        }
      }, 100);
    })();

    // UI interactions
    document.getElementById('goHome').addEventListener('click', function(){
      window.location.href = '/'; // change to your app/dashboard URL if needed
    });
    document.getElementById('closeBtn').addEventListener('click', function(){
      // In a WebView the Android side may close this window; otherwise just try window.close()
      try { window.close(); } catch(e) { /* ignore */ }
    });

    // Announce for screen readers (accessibility)
    (function(){
      var sr = document.createElement('div');
      sr.setAttribute('aria-live','polite');
      sr.setAttribute('style','position:absolute;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden;');
      sr.textContent = "Fees Paid Successfully";
      document.body.appendChild(sr);
    })();
  </script>
</body>
</html>
