<?php
// combined_pay.php
// Creates a Cashfree order. Sends feesId, feesTypeId and amountdetails (base64) to return/notify URLs.
// Does NOT insert into DB here — insertion happens only in callback.php when payment is successful.

$servername = 'localhost';
$username   = 'goverdhanschool_g';
$password   = 'x}Sh0E4?WTfU';
$dbname     = 'goverdhanschool_g';

$base_url = "https://goverdhanschool.com/cashfee";
$payMode  = "production"; // change to 'sandbox' for testing

if ($payMode === 'production') {
    define('CLIENT_ID', "10423844c405d78f2be3a65f1a84832401");
    define('SECRET_KEY', "cfsk_ma_prod_e22f3ec5dfe408ccf58be5d0a492fc96_edaa580c");
    $APIURL = "https://api.cashfree.com/pg/orders";
} else {
    define('CLIENT_ID', "TEST10731942f4e73eca6cf6b4e6f1dd24913701");
    define('SECRET_KEY', "cfsk_ma_test_4e5733bea36fb1094d2de073ae781608_81830881");
    $APIURL = "https://sandbox.cashfree.com/pg/orders";
}

// Demo fallbacks
$DEMO_AMOUNT     = '1000.00';
$DEMO_FIRSTNAME  = 'Demo Student';
$DEMO_MOBILENO   = '9999999999';
$DEMO_EMAIL      = 'demo@student.com';

// helper
function generateOrderId($prefix = '') {
    $uniqid = uniqid($prefix, true);
    $randomNumber = mt_rand(100000, 999999);
    $orderId = $uniqid . $randomNumber;
    $orderId = hash('sha256', $orderId);
    return substr(strtoupper($orderId), 0, 20);
}

// DB connection for lookups
$mysqli = new mysqli($servername, $username, $password, $dbname);
if (!$mysqli->set_charset('utf8mb4')) { /* ignore */ }

// Read POST or raw JSON
$input = $_POST;
$raw = '';
if (empty($input)) {
    $raw = file_get_contents('php://input');
    $json = json_decode($raw, true);
    if (is_array($json)) $input = $json;
}

// Logging incoming
$logFile = __DIR__ . "/log.txt";
$logData = "=== " . date("Y-m-d H:i:s") . " (combined_pay.php) ===\n";
$logData .= "RAW INPUT:\n" . ($raw ?? '') . "\n";
$logData .= "POST:\n" . print_r($_POST, true) . "\n";
$logData .= "INPUT:\n" . print_r($input, true) . "\n\n";
file_put_contents($logFile, $logData, FILE_APPEND);

// Get user-supplied fields
$feesTypeId = isset($input['feesTypeId']) ? trim($input['feesTypeId']) : null;
$studentId  = isset($input['studentId'])  ? trim($input['studentId'])  : null;
$feesMasterId = isset($input['feesId']) ? trim($input['feesId']) : null; // student_fees_master_id
$amountdetails_input = null;

// Normalize amountdetails if present
if (isset($input['amountdetails'])) {
    if (is_array($input['amountdetails'])) {
        $amountdetails_input = $input['amountdetails'];
    } else {
        $try = json_decode($input['amountdetails'], true);
        $amountdetails_input = ($try === null) ? ['raw' => $input['amountdetails']] : $try;
    }
}

// Amount lookup
$amountToShow = $DEMO_AMOUNT;
if (!$mysqli->connect_errno && $feesTypeId !== null && $feesTypeId !== '') {
    $stmt = $mysqli->prepare('SELECT amount FROM fee_groups_feetype WHERE id = ? LIMIT 1');
    if ($stmt) {
        $stmt->bind_param('i', $feesTypeId);
        if ($stmt->execute()) {
            $res = $stmt->get_result();
            if ($row = $res->fetch_assoc()) {
                if (isset($row['amount']) && trim((string)$row['amount']) !== '') {
                    $amountToShow = number_format((float)$row['amount'], 2, '.', '');
                }
            }
        } else {
            file_put_contents($logFile, "Amount lookup execute error: " . $stmt->error . "\n", FILE_APPEND);
        }
        $stmt->close();
    } else {
        file_put_contents($logFile, "Amount lookup prepare error: " . $mysqli->error . "\n", FILE_APPEND);
    }
}
if (!is_numeric($amountToShow)) $amountToShow = $DEMO_AMOUNT;
else $amountToShow = number_format((float)$amountToShow, 2, '.', '');

// Student lookup
$studentData = ['firstname' => $DEMO_FIRSTNAME, 'mobileno' => $DEMO_MOBILENO, 'email' => $DEMO_EMAIL];
if (!$mysqli->connect_errno && $studentId !== null && $studentId !== '') {
    $stmt2 = $mysqli->prepare('SELECT firstname, mobileno, email FROM students WHERE id = ? LIMIT 1');
    if ($stmt2) {
        $stmt2->bind_param('i', $studentId);
        if ($stmt2->execute()) {
            $res2 = $stmt2->get_result();
            if ($s = $res2->fetch_assoc()) {
                $studentData['firstname'] = (isset($s['firstname']) && trim((string)$s['firstname']) !== '') ? $s['firstname'] : $DEMO_FIRSTNAME;
                $studentData['mobileno']  = (isset($s['mobileno'])  && trim((string)$s['mobileno'])  !== '') ? $s['mobileno']  : $DEMO_MOBILENO;
                $studentData['email']     = (isset($s['email'])     && trim((string)$s['email'])     !== '') ? $s['email']     : $DEMO_EMAIL;
            }
        } else {
            file_put_contents($logFile, "Student lookup execute error: " . $stmt2->error . "\n", FILE_APPEND);
        }
        $stmt2->close();
    } else {
        file_put_contents($logFile, "Student lookup prepare error: " . $mysqli->error . "\n", FILE_APPEND);
    }
}
if ($mysqli) $mysqli->close();

// Prepare order data
$orderId = generateOrderId('ORD_');
$customer_id = $studentId ? 'STU' . $studentId : 'STU_DEMO_' . mt_rand(1000,9999);
$customer_name  = $studentData['firstname'];
$customer_email = $studentData['email'];
$customer_phone = $studentData['mobileno'];

// Build return & notify URLs with encoded extra params so callback can know feesId, feesTypeId, amountdetails
// We base64_encode a JSON of amountdetails to safely pass complex JSON inside a query param.
$extra = [
    'feesId' => $feesMasterId,
    'feesTypeId' => $feesTypeId,
    // don't include heavy payloads in URLs in production — this is for convenience
    'amountdetails_b64' => $amountdetails_input ? base64_encode(json_encode($amountdetails_input)) : null
];
$extra_q = http_build_query($extra);

// return_url (used for redirect user) and notify_url (webhook) — both include the extras
$return_url = "https://goverdhanschool.com/cashfee/success.php?order_id=" . rawurlencode($orderId) . '&' . $extra_q;
$notify_url = "https://goverdhanschool.com/cashfee/callback.php?order_id=" . rawurlencode($orderId) . '&' . $extra_q;

// Build payload
$payload = [
    "order_id" => $orderId,
    "order_amount" => (float)$amountToShow,
    "order_currency" => "INR",
    "customer_details" => [
        "customer_id"    => $customer_id,
        "customer_name"  => $customer_name,
        "customer_email" => $customer_email,
        "customer_phone" => $customer_phone
    ],
    "order_meta" => [
        "return_url" => $return_url,
        "notify_url" => $notify_url,
        "payment_methods" => "cc,dc,upi"
    ]
];

// Call Cashfree to create order
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $APIURL,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        'X-Client-Id: ' . CLIENT_ID,
        'X-Client-Secret: ' . SECRET_KEY,
        'Content-Type: application/json',
        'Accept: application/json',
        'x-api-version: 2023-08-01'
    ],
    CURLOPT_TIMEOUT => 30,
]);

$response = curl_exec($ch);
$curlErr = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($curlErr) {
    header('Content-Type: text/plain; charset=utf-8');
    echo "CURL ERROR: " . $curlErr . PHP_EOL;
    echo "Request Payload:" . PHP_EOL . json_encode($payload, JSON_PRETTY_PRINT) . PHP_EOL;
    file_put_contents($logFile, "CURL ERROR: $curlErr\nPayload: " . json_encode($payload) . "\n", FILE_APPEND);
    exit;
}

$resData = json_decode($response, true);

// success? Cashfree returns cf_order_id and payment_session_id
if (is_array($resData) && !empty($resData['cf_order_id']) && !empty($resData['payment_session_id'])) {
    $paymentSessionId = $resData['payment_session_id'];
    $cf_order_id      = $resData['cf_order_id'];

    // Log successful creation
    file_put_contents($logFile, "Order created: order_id={$orderId} cf_order_id={$cf_order_id} payment_session_id={$paymentSessionId}\nPayload: " . json_encode($payload) . "\nResponse: " . $response . "\n", FILE_APPEND);

    // Render Cashfree checkout HTML (redirect user)
    ?>
    <!DOCTYPE html>
    <html lang="en">
      <head>
        <meta charset="UTF-8" />
        <title>Processing Payment...</title>
        <script src="https://sdk.cashfree.com/js/v3/cashfree.js"></script>
      </head>
      <body>
        <h3 style="text-align:center;">Redirecting to Payment Gateway...</h3>
        <script>
          const cashfree = Cashfree({ mode: "<?php echo htmlspecialchars($payMode, ENT_QUOTES); ?>" });
          window.onload = function(){
              cashfree.checkout({
                paymentSessionId: "<?php echo htmlspecialchars($paymentSessionId, ENT_QUOTES); ?>"
              });
          };
        </script>
      </body>
    </html>
    <?php
    exit;
} else {
    header('Content-Type: text/plain; charset=utf-8');
    echo "Cashfree error or unexpected response (HTTP code: " . intval($httpCode) . "):" . PHP_EOL;
    echo $response . PHP_EOL . PHP_EOL;
    echo "Used payload:" . PHP_EOL . json_encode($payload, JSON_PRETTY_PRINT) . PHP_EOL;
    file_put_contents($logFile, "Cashfree unexpected response HTTP {$httpCode}: " . $response . "\nPayload: " . json_encode($payload) . "\n", FILE_APPEND);
    exit;
}
