<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Pesapal extends Admin_Controller {

    var $setting;
    var $payment_method;
    var $api_config;

    public function __construct() {
        parent::__construct();

        $this->setting = $this->setting_model->get();
        $this->payment_method = $this->paymentsetting_model->get();
        $this->api_config = $this->paymentsetting_model->getActiveMethod();
        $this->load->library('pesapal_lib');
    }

    public function index() {

        $data = array();
        $data['params'] = $this->session->userdata('params');
           $data['student_data'] = $this->student_model->get($data['params']['student_id']);
        $data['setting'] = $this->setting;
        $data['api_error'] = array();
     
        $this->load->view('payment/pesapal/index', $data);
    }
 
   public function pesapal_pay(){

        $this->form_validation->set_rules('phone', ('Phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', ('Email'), 'trim|required|xss_clean');

        if ($this->form_validation->run()==false) {
        $data = array();
        $data['params'] = $this->session->userdata('params');
        $data['setting'] = $this->setting;
        $data['api_error']=$data['api_error']=array();
        $data['student_data']=$this->student_model->get($data['params']['student_id']);
         $this->load->view('payment/pesapal/index', $data);

        }else{


        $pesapal_details=$this->paymentsetting_model->getActiveMethod();
        $params = $this->session->userdata('params');
        $data = array();
        $student_fees_master_id = $params['student_fees_master_id'];
        $fee_groups_feetype_id = $params['fee_groups_feetype_id'];
        $student_id = $params['student_id'];
        $total=number_format((float)(convertBaseAmountCurrencyFormat($params['payment_detail']->fine_amount+$params['total'])), 2, '.', '');
        $data['student_fees_master_id'] = $student_fees_master_id;
        $data['fee_groups_feetype_id'] = $fee_groups_feetype_id;
        $data['student_id'] = $student_id;
        $data['total'] = $total;
        $data['symbol'] = $params['invoice']->symbol;
        $data['currency_name'] = $params['invoice']->currency_name;
        $data['name'] = $params['name'];
        $data['guardian_phone'] = $params['guardian_phone'];
        $amount = $data['total'];

        
        $token = $params = NULL;
        $consumer_key = $pesapal_details->api_publishable_key;;//Register a merchant account on
                           //demo.pesapal.com and use the merchant key for testing.
                           //When you are ready to go live make sure you change the key to the live account
                           //registered on www.pesapal.com!
        $consumer_secret = $pesapal_details->api_secret_key;;// Use the secret from your test
                           //account on demo.pesapal.com. When you are ready to go live make sure you 
                           //change the secret to the live account registered on www.pesapal.com!
        $signature_method = new OAuthSignatureMethod_HMAC_SHA1();
        $iframelink = 'https://www.pesapal.com/API/PostPesapalDirectOrderV4';//change to      
                           //https://www.pesapal.com/API/PostPesapalDirectOrderV4 when you are ready to go live!

        //get form details<br>$amount = $_POST['amount'];
        $amount = number_format($amount, 2);//format amount to 2 decimal places
        $desc = "Student Fee Payment";
        $type = 'MERCHANT'; //default value = MERCHANT
        $reference = time();//unique order id of the transaction, generated by merchant
        $first_name = $data['name']; //[optional]
        $last_name = ''; //[optional]
        $email = $_POST['email'];
        $phonenumber = $_POST['phone']; //ONE of email or phonenumber is required

        $callback_url = base_url('gateway/pesapal/pesapal_response'); //redirect url, the page that will handle the response from pesapal.
        $post_xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><PesapalDirectOrderInfo xmlns:xsi=\"http://www.w3.org/2001/XMLSchemainstance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" Amount=\"".$amount."\" Description=\"".$desc."\" Type=\"".$type."\" Reference=\"".$reference."\" FirstName=\"".$first_name."\" LastName=\"".$last_name."\" Email=\"".$email."\" PhoneNumber=\"".$phonenumber."\" xmlns=\"http://www.pesapal.com\" />";
        $post_xml = htmlentities($post_xml);

        $consumer = new OAuthConsumer($consumer_key, $consumer_secret);
        //post transaction to pesapal

        $iframe_src = OAuthRequest::from_consumer_and_token($consumer, $token, "GET",
        $iframelink, $params);

        $iframe_src->set_parameter("oauth_callback", $callback_url);
        $iframe_src->set_parameter("pesapal_request_data", $post_xml);
        $iframe_src->sign_request($signature_method, $consumer, $token);

        $consumer = new OAuthConsumer($consumer_key, $consumer_secret);
        //post transaction to pesapal

        $iframe_src = OAuthRequest::from_consumer_and_token($consumer, $token, "GET",
        $iframelink, $params);
        $iframe_src->set_parameter("oauth_callback", $callback_url);
        $iframe_src->set_parameter("pesapal_request_data", $post_xml);
        $iframe_src->sign_request($signature_method, $consumer, $token);
        $data['iframe_src']=$iframe_src;
        $this->load->view('payment/pesapal/pay', $data);
        
        }
}
      

    public function pesapal_response(){
 $pesapal_details=$this->paymentsetting_model->getActiveMethod();
        $reference = null;

        $pesapal_tracking_id = null;

        if(isset($_GET['pesapal_merchant_reference'])){
             $reference = $_GET['pesapal_merchant_reference'];
        }

       

        if(isset($_GET['pesapal_transaction_tracking_id'])){
            $pesapal_tracking_id = $_GET['pesapal_transaction_tracking_id'];
        }

        

        //store $pesapal_tracking_id in your database against the order with orderid = $reference

 $consumer_key = $pesapal_details->api_publishable_key;;//Register a merchant account on
                           //demo.pesapal.com and use the merchant key for testing.
                           //When you are ready to go live make sure you change the key to the live account
                           //registered on www.pesapal.com!
        $consumer_secret = $pesapal_details->api_secret_key;;// Use the secret from your test

                   //account on demo.pesapal.com. When you are ready to go live make sure you
  //change the secret to the live account registered on www.pesapal.com!
$statusrequestAPI = 'https://www.pesapal.com/api/querypaymentstatus';//change to     

//https://www.pesapal.com/api/querypaymentstatus' when you are ready to go live!

// Parameters sent to you by PesaPal IPN

//$pesapalNotification=$_GET['pesapal_notification_type'];

$pesapalTrackingId=$_GET['pesapal_transaction_tracking_id'];

$pesapal_merchant_reference=$_GET['pesapal_merchant_reference'];



if($pesapalTrackingId!='')

{

   $token = $params = NULL;

   $consumer = new OAuthConsumer($consumer_key, $consumer_secret);

   $signature_method = new OAuthSignatureMethod_HMAC_SHA1();


   $request_status = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $statusrequestAPI, $params);

   $request_status->set_parameter("pesapal_merchant_reference", $pesapal_merchant_reference);

   $request_status->set_parameter("pesapal_transaction_tracking_id",$pesapalTrackingId);

   $request_status->sign_request($signature_method, $consumer, $token);

 

   $ch = curl_init();

   curl_setopt($ch, CURLOPT_URL, $request_status);

   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

   curl_setopt($ch, CURLOPT_HEADER, 1);

   curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

   if(defined('CURL_PROXY_REQUIRED')) if (CURL_PROXY_REQUIRED == 'True')

   {

      $proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;

      curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);

      curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);

      curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);

   }

 

   $response = curl_exec($ch);

 

   $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);

   $raw_header  = substr($response, 0, $header_size - 4);

   $headerArray = explode("\r\n\r\n", $raw_header);

   $header      = $headerArray[count($headerArray) - 1];

 


   $elements = preg_split("/=/",substr($response, $header_size));

   $status = $elements[1];

   if($status=='COMPLETED'){

      $params = $this->session->userdata('params');
      $total=number_format((float)($params['payment_detail']->fine_amount+$params['total']), 2, '.', '');
      $ref_id = $pesapalTrackingId;
      $json_array = array(
          'amount' => $params['total'],
          'date' => date('Y-m-d'),
          'amount_discount' => 0,
          'amount_fine' => $params['payment_detail']->fine_amount,
          'description' => "Online fees deposit through Pesapal Txt ID: " . $pesapalTrackingId,
          'received_by' => '',
          'payment_mode' => 'Pesapal',
      );
      if(($params['fee_category']=='transport') && !empty($params['student_transport_fee_id']) ){
                    $data = array(
                    'student_transport_fee_id' => $params['student_transport_fee_id'],
                    'amount_detail' => $json_array,
                );
                }else{
                    $data = array(
                    'student_fees_master_id' => $params['student_fees_master_id'],
                    'fee_groups_feetype_id' => $params['fee_groups_feetype_id'],
                    'amount_detail' => $json_array,
                );
                }
      $send_to = $params['guardian_phone'];
      $inserted_id = $this->studentfeemaster_model->fee_deposit($data, $send_to, '');
      $invoice_detail = json_decode($inserted_id);
      redirect(base_url("payment/successinvoice/" . $invoice_detail->invoice_id . "/" . $invoice_detail->sub_invoice_id));

    }else{

       redirect(base_url("payment/paymentfailed"));

    }
}
 

   curl_close ($ch);


    }
}
