<?php

namespace Omnipay\GoCardless\Message;

use Omnipay\Common\Message\AbstractResponse;
use Omnipay\Common\Message\RedirectResponseInterface;
use Omnipay\GoCardless\Gateway;

/**
 * GoCardless Purchase Response
 */
class PurchaseResponse extends AbstractResponse implements RedirectResponseInterface {

    public function isSuccessful() {
        return false;
    }

    public function isRedirect() {
        return true;
    }

    public function getRedirectUrl() {
        return $this->getRequest()->getEndpoint() . '/connect/bills/new?' . Gateway::generateQueryString($this->data);
    }

    public function getRedirectMethod() {
        return 'GET';
    }

    public function getRedirectData() {
        return null;
    }

}
